/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.EntityType;

@MythicCondition(author="Ashijin", name="mobsinradius", aliases={}, description="Matches a range to how many mobs are in the given radius")
public class MobsInRadiusCondition
extends SkillCondition
implements ISkillMetaCondition,
ILocationCondition {
    @MythicField(name="types", aliases={"types", "t"}, description="The mobtype to check for")
    private HashSet<MythicMob> mmTypes = new HashSet();
    private HashSet<BukkitEntityType> meTypes = new HashSet();
    private HashSet<EntityType> vanillaTypes = new HashSet();
    @MythicField(name="amount", aliases={"a"}, description="The number range to match")
    private final RangedDouble amount;
    @MythicField(name="radius", aliases={"r"}, description="The radius to check")
    private final PlaceholderDouble radius;
    final Set<String> mappedEntityTypes = Arrays.stream(EntityType.values()).map(Enum::toString).collect(Collectors.toSet());

    public MobsInRadiusCondition(String line, MythicLineConfig mlc) {
        super(line);
        String k = mlc.getString(new String[]{"amount", "a"}, "1", this.conditionVar);
        this.amount = new RangedDouble(k);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, "5", this.conditionVar);
        String types = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] ss = types.split(",");
        MobsInRadiusCondition.getPlugin().getSkillManager().queueSecondPass(() -> {
            for (String s2 : ss) {
                MythicMob mm4;
                if (this.mappedEntityTypes.contains(s2.toUpperCase())) {
                    this.vanillaTypes.add(EntityType.valueOf((String)s2.toUpperCase()));
                }
                if ((mm4 = MobsInRadiusCondition.getPlugin().getMobManager().getMythicMob(s2).orElseGet(() -> null)) != null) {
                    this.mmTypes.add(mm4);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    this.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorConditionConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "MobsInRadius loaded " + (this.meTypes.size() + this.mmTypes.size()) + " types", new Object[0]);
        });
    }

    @Override
    public boolean check(SkillMetadata meta) {
        SkillCaster caster = meta.getCaster();
        AbstractLocation location = caster.getEntity().getLocation();
        double radius = this.radius.get(meta, meta.getCaster().getEntity());
        double radiusSq = Math.pow(radius, 2.0);
        Collection<AbstractEntity> found = MobsInRadiusCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(location, radius, entity -> {
            if (entity.getUniqueId().equals(caster.getEntity().getUniqueId())) {
                return false;
            }
            if (location.distanceSquared(entity.getLocation()) > radiusSq) {
                return false;
            }
            if (this.vanillaTypes.contains(entity.getBukkitEntity().getType())) {
                return true;
            }
            if (!MobsInRadiusCondition.getPlugin().getMobManager().isLoadedMob((AbstractEntity)entity)) {
                return false;
            }
            ActiveMob amCompare = MobsInRadiusCondition.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)entity);
            if (amCompare != null) {
                return this.mmTypes.contains(amCompare.getType());
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(entity.getBukkitEntity())) continue;
                return true;
            }
            return false;
        });
        return this.amount.equals(found.size());
    }

    @Override
    public boolean check(AbstractLocation location) {
        double radius = this.radius.get();
        double radiusSq = Math.pow(radius, 2.0);
        Collection<AbstractEntity> found = MobsInRadiusCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(location, radius, entity -> {
            if (location.distanceSquared(entity.getLocation()) > radiusSq) {
                return false;
            }
            if (this.vanillaTypes.contains(entity.getBukkitEntity().getType())) {
                return true;
            }
            if (!MobsInRadiusCondition.getPlugin().getMobManager().isLoadedMob((AbstractEntity)entity)) {
                return false;
            }
            ActiveMob amCompare = MobsInRadiusCondition.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)entity);
            if (amCompare != null) {
                return this.mmTypes.contains(amCompare.getType());
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(entity.getBukkitEntity())) continue;
                return true;
            }
            return false;
        });
        return this.amount.equals(found.size());
    }
}

