/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Joshinn", name="hasoffhand", aliases={"offhand"}, description="Tests if the target entity has something in offhand.")
public class HasOffhandCondition
extends SkillCondition
implements IEntityCondition {
    public HasOffhandCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity e) {
        Entity entity = e.getBukkitEntity();
        if (!(entity instanceof LivingEntity)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target is not a LivingEntity, returning false", new Object[0]);
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        EntityEquipment equipment = living.getEquipment();
        if (equipment == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Target cannot equip items, returning false", new Object[0]);
            return false;
        }
        ItemStack item = equipment.getItemInOffHand();
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "In offhand condition, offhand was empty, returning false.", new Object[0]);
            return false;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "In offhand condition, offhand was not empty, returning true.", new Object[0]);
        return true;
    }
}

