/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.commands;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.commands.CustomCommandFunction;
import io.lumine.mythic.core.skills.commands.CustomCommandTabCompleteFunction;
import io.lumine.mythic.core.utils.MythicUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class CommandSkillExecutor
implements Listener {
    private static final Set<MetaSkillCommand> COMMANDS = new HashSet<MetaSkillCommand>();
    private final Map<String, Function<MythicConfig, CustomCommandFunction>> commandFunctions = Maps.newConcurrentMap();
    private final Map<String, Function<MythicConfig, CustomCommandTabCompleteFunction>> tabCompleteFunctions = Maps.newConcurrentMap();

    public CommandSkillExecutor() {
        this.registerCustomCommandFunction("echo", mc -> (player, args, config) -> player.sendMessage(mc.getString("Message")));
        this.registerCustomCommandTabCompleteFunction("$worlds", c -> (player, args) -> Bukkit.getWorlds().stream().map(w -> w.getName()).toList());
        this.registerCustomCommandTabCompleteFunction("$players", c -> (player, args) -> Bukkit.getOnlinePlayers().stream().map(p -> p.getName()).toList());
        this.registerCustomCommandTabCompleteFunction("$items", c -> (player, args) -> {
            ArrayList<String> list = new ArrayList<String>();
            for (ItemType m4 : Registry.ITEM) {
                list.add(m4.getKey().value());
            }
            return list;
        });
        this.registerCustomCommandTabCompleteFunction("$enchantments", c -> (player, args) -> {
            ArrayList<String> list = new ArrayList<String>();
            for (Enchantment m4 : Registry.ENCHANTMENT) {
                list.add(m4.getKey().toString());
            }
            return list;
        });
        this.registerCustomCommandTabCompleteFunction("$mythicitems", c -> (player, args) -> new ArrayList<String>(MythicBukkit.inst().getItemManager().getItemNames()));
    }

    public void reloadCommands() {
        CommandSkillExecutor.popCommands();
        this.loadCommands();
        CommandSkillExecutor.pushCommands();
        CommandSkillExecutor.syncCommands();
    }

    static void popCommands() {
        COMMANDS.forEach(c -> Bukkit.getCommandMap().getKnownCommands().remove(c.getName()));
    }

    void loadCommands() {
        COMMANDS.clear();
        for (Skill skill : MythicBukkit.inst().getSkillManager().getSkills()) {
            CustomCommandFunction commandFunction;
            MythicConfig config;
            String id;
            if (skill.getConfig() == null || !skill.getConfig().isSet("Command") || (id = (config = skill.getConfig().getNestedConfig("Command")).getString("Id", null)) == null) continue;
            if (config.isSet("Function")) {
                if (config.isConfigurationSection("Function")) {
                    MythicConfig sub = config.getNestedConfig("Function");
                    commandFunction = this.getCommandFunction(sub.getString("Type"), sub).orElse(null);
                } else {
                    commandFunction = this.getCommandFunction(config.getString("Function"), null).orElse(null);
                }
            } else {
                commandFunction = null;
            }
            List<String> aliases = config.getStringList("Aliases", List.of());
            MythicConfig completionsConfig = config.isConfigurationSection("Completions") ? config.getNestedConfig("Completions") : null;
            this.makeCommand(id, skill.getInternalName(), config, commandFunction, completionsConfig);
            aliases.forEach(a -> this.makeCommand((String)a, skill.getInternalName(), config, commandFunction, completionsConfig));
        }
        MythicLogger.log("Loaded {0} skill commands", COMMANDS.size());
    }

    static void pushCommands() {
        for (MetaSkillCommand c : COMMANDS) {
            Bukkit.getCommandMap().getKnownCommands().put(c.getName(), c);
            Bukkit.getServer().getCommandMap().register(MythicBukkit.inst().getName(), (Command)c);
        }
    }

    static void syncCommands() {
        try {
            Method m4 = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            m4.setAccessible(true);
            m4.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void makeCommand(String name, String skill, MythicConfig commandConfig, CustomCommandFunction commandFunction, MythicConfig completionsConfig) {
        MetaSkillCommand cmd = new MetaSkillCommand(name.toLowerCase(), skill, commandConfig, commandFunction);
        if (completionsConfig != null) {
            for (String key : completionsConfig.getKeys()) {
                List<String> literals = completionsConfig.getStringList(key, List.of());
                CustomCommandTabCompleteFunction tabFunction = null;
                if (!literals.isEmpty()) {
                    String first = literals.get(0);
                    tabFunction = this.getTabCompleteFunction(first, completionsConfig).orElse(null);
                }
                cmd.addCompletion(key, literals, tabFunction);
            }
        }
        COMMANDS.add(cmd);
    }

    public void registerCustomCommandFunction(String key, Function<MythicConfig, CustomCommandFunction> function) {
        this.commandFunctions.put(key.toUpperCase(), function);
    }

    public void registerCustomCommandTabCompleteFunction(String key, Function<MythicConfig, CustomCommandTabCompleteFunction> function) {
        this.tabCompleteFunctions.put(key.toUpperCase(), function);
    }

    Optional<CustomCommandFunction> getCommandFunction(String key, MythicConfig config) {
        Function<MythicConfig, CustomCommandFunction> f = this.commandFunctions.get(key.toUpperCase());
        return f == null ? Optional.empty() : Optional.ofNullable(f.apply(config));
    }

    Optional<CustomCommandTabCompleteFunction> getTabCompleteFunction(String key, MythicConfig config) {
        Function<MythicConfig, CustomCommandTabCompleteFunction> f = this.tabCompleteFunctions.get(key.toUpperCase());
        return f == null ? Optional.empty() : Optional.ofNullable(f.apply(config));
    }

    static class MetaSkillCommand
    extends Command {
        String skill;
        MythicConfig commandConfig;
        CustomCommandFunction commandFunction;
        LinkedList<Pair<String, List<String>>> commandCompletions = new LinkedList();
        List<CustomCommandTabCompleteFunction> tabFunctions = new ArrayList<CustomCommandTabCompleteFunction>();

        protected MetaSkillCommand(String name, String skill, MythicConfig commandConfig, CustomCommandFunction commandFunction) {
            super(name, "", "", List.of());
            this.skill = skill;
            this.commandConfig = commandConfig;
            this.commandFunction = commandFunction;
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String s2, @NotNull String[] args) {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player = (Player)sender;
            LivingEntity target = MythicUtil.getTargetedEntity(player);
            ArrayList<Entity> targets = new ArrayList<Entity>();
            targets.add((Entity)target);
            MythicBukkit.inst().getAPIHelper().castSkill((Entity)player, this.skill, (Entity)player, player.getLocation(), targets, null, 1.0f, meta -> {
                Log.info("execute command");
                if (this.commandFunction != null) {
                    Log.info("execute function");
                    this.commandFunction.execute(player, args, (SkillMetadata)meta);
                }
                for (int i = 0; i < Math.min(args.length, this.commandCompletions.size()); ++i) {
                    meta.getVariables().putString((String)this.commandCompletions.get(i).getKey(), args[i]);
                }
                if (args.length > this.commandCompletions.size()) {
                    meta.getVariables().putString("excessArgs", String.join((CharSequence)" ", Arrays.copyOfRange(args, this.commandCompletions.size(), args.length)));
                }
            });
            return true;
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            if (!(sender instanceof Player)) {
                return List.of();
            }
            Player player = (Player)sender;
            int index = args.length - 1;
            ArrayList<String> results = new ArrayList<String>();
            if (index < this.tabFunctions.size()) {
                CustomCommandTabCompleteFunction fn = this.tabFunctions.get(index);
                if (fn != null) {
                    return CollectionUtils.filterMatches(args[index], fn.tabComplete(player, args), 2);
                }
                if (index < this.commandCompletions.size()) {
                    results.addAll(CollectionUtils.filterMatches(args[index], (Collection)this.commandCompletions.get(index).getValue(), 2));
                }
            }
            return results;
        }

        public void addCompletion(String key, List<String> literals, CustomCommandTabCompleteFunction tabFunction) {
            this.commandCompletions.add((Pair<String, List<String>>)Pair.of((Object)key, literals));
            this.tabFunctions.add(tabFunction);
        }
    }
}

