/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class SkillTargeter {
    private final MythicBukkit plugin;
    private final SkillExecutor manager;
    protected MythicLineConfig config;
    protected Optional<SkillHolder> parent = Optional.empty();
    protected String targetConditionString;
    protected List<SkillCondition> targetConditions = null;
    protected boolean sudoParent;
    protected boolean sudoOwner;
    protected boolean sudoTrigger;
    protected SkillTargeter fallback;

    public SkillTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.config = mlc;
        this.targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        this.sudoParent = mlc.getBoolean(new String[]{"parent", "asparent", "ofparent", "fromparent", "sudoparent"}, false);
        this.sudoOwner = mlc.getBoolean(new String[]{"owner", "asowner", "ofowner", "fromowner", "sudoowner"}, false);
        this.sudoTrigger = mlc.getBoolean(new String[]{"trigger", "astrigger", "oftrigger", "fromtrigger", "sudotrigger"}, false);
        if (MythicBukkit.isVolatile() && this.targetConditionString != null) {
            this.targetConditions = this.getPlugin().getSkillManager().getConditions(this.targetConditionString);
        }
        String fallbackTargeterString = mlc.getString(new String[]{"fallback", "fb"}, "", new String[0]);
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            if (fallbackTargeterString.isBlank()) {
                return;
            }
            this.fallback = this.getPlugin().getSkillManager().getTargeter(fallbackTargeterString);
        });
    }

    public void setParent(SkillHolder parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected Collection<AbstractLocation> getMetaLocations(SkillMetadata data) {
        ArrayList locations;
        block3: {
            block2: {
                locations = Lists.newArrayList();
                if (data.getEntityTargets() == null || data.getEntityTargets().isEmpty()) break block2;
                for (AbstractEntity entity : data.getEntityTargets()) {
                    locations.add(entity.getLocation());
                }
                break block3;
            }
            if (data.getLocationTargets() == null || data.getLocationTargets().isEmpty()) break block3;
            for (AbstractLocation location : data.getLocationTargets()) {
                locations.add(location);
            }
        }
        return locations;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SkillExecutor getManager() {
        return this.manager;
    }

    public Optional<SkillHolder> getParent() {
        return this.parent;
    }

    public boolean isSudoParent() {
        return this.sudoParent;
    }

    public boolean isSudoOwner() {
        return this.sudoOwner;
    }

    public boolean isSudoTrigger() {
        return this.sudoTrigger;
    }

    public SkillTargeter getFallback() {
        return this.fallback;
    }
}

