/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillManager;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.targeters.IEntityTargeter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.adapters.VirtualEntity;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.EventExecutor;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillCasterProvider;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.audience.CustomAudience;
import io.lumine.mythic.core.skills.audience.TargeterAudience;
import io.lumine.mythic.core.skills.auras.AuraExecutor;
import io.lumine.mythic.core.skills.commands.CommandSkillExecutor;
import io.lumine.mythic.core.skills.conditions.CompositeCondition;
import io.lumine.mythic.core.skills.conditions.CustomCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.MetaSkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.CustomTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import io.lumine.mythic.core.skills.targeters.VanillaTargeter;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicAudience;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class SkillExecutor
extends ReloadableModule<MythicBukkit>
implements SkillManager {
    private static final Map<String, Class<? extends SkillCondition>> CONDITIONS = new ConcurrentHashMap<String, Class<? extends SkillCondition>>();
    private static final Map<String, Class<? extends SkillMechanic>> MECHANICS = new ConcurrentHashMap<String, Class<? extends SkillMechanic>>();
    private static final Map<String, Class<? extends SkillTargeter>> TARGETERS = new ConcurrentHashMap<String, Class<? extends SkillTargeter>>();
    private static final Map<String, Class<? extends SkillAudience>> AUDIENCES = new ConcurrentHashMap<String, Class<? extends SkillAudience>>();
    private List<File> skillFiles;
    private IOLoader<MythicBukkit> defaultSkills;
    private List<IOLoader<MythicBukkit>> skillLoaders;
    private Map<String, Skill> skills = Maps.newConcurrentMap();
    private final ConcurrentMap<String, SkillMechanic> mechanicCache = new ConcurrentHashMap<String, SkillMechanic>();
    private final ConcurrentMap<String, SkillCondition> conditionCache = new ConcurrentHashMap<String, SkillCondition>();
    private final ConcurrentMap<String, SkillTargeter> targeterCache = new ConcurrentHashMap<String, SkillTargeter>();
    private AuraExecutor auraManager;
    private EventExecutor eventBus;
    private CommandSkillExecutor commandSkillExecutor;
    private SkillCasterProvider skillCasterProvider = null;
    private static final ConcurrentMap<UUID, ConcurrentMap<UUID, Long>> COOLDOWNS = new ConcurrentHashMap<UUID, ConcurrentMap<UUID, Long>>();
    private int saved = 0;

    public SkillExecutor(MythicBukkit core) {
        super(core, false);
        this.loadSkillComponents();
        this.load(core);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.auraManager = new AuraExecutor((MythicPlugin)this.getPlugin(), this);
        this.eventBus = new EventExecutor((MythicPlugin)this.getPlugin(), this);
        if (MythicBukkit.isVolatile() || ((MythicBukkit)this.getPlugin()).getCompatibility().getRpg().isPresent()) {
            this.commandSkillExecutor = new CommandSkillExecutor();
        }
        SkillExecutor.loadMechanics();
    }

    @Override
    public void unload() {
        this.mechanicCache.clear();
        this.auraManager.shutdown();
        Projectile.BULLET_ENTITIES.forEach(AbstractEntity::remove);
    }

    public void loadSkills() {
        MythicLogger.log("Loading Skills...");
        this.defaultSkills = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.getFile().getParent());
        this.skills.clear();
        this.mechanicCache.clear();
        this.targeterCache.clear();
        this.conditionCache.clear();
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            for (File folder : pack.getPackFolders("Skills", true, true)) {
                for (File file : Files.getAll(folder.getAbsolutePath(), Lists.newArrayList((Object[])new String[]{"yml", "txt"}))) {
                    MythicConfigImpl fileConfig = new MythicConfigImpl(file);
                    for (String node : NodeListProp.getNodes(file, "")) {
                        try {
                            MythicConfig config = fileConfig.getNestedConfig(node);
                            if (folder.getName().equals("mono") && (config.isSet("Id") || config.isSet("Type"))) continue;
                            MetaSkill ms = new MetaSkill(this, pack, file, node, config);
                            this.skills.put(node, ms);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("Error loading skill '" + node + "'. Enable debugging for a stack trace.");
                            MythicLogger.handleMinorError(ex);
                        }
                    }
                }
            }
        }
        this.queueAfterLoad(() -> {
            if (this.commandSkillExecutor != null) {
                this.commandSkillExecutor.reloadCommands();
            }
            this.mechanicCache.clear();
            this.targeterCache.clear();
            this.conditionCache.clear();
        });
    }

    @Override
    public void queueAfterLoad(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueAfterLoad(r);
    }

    @Override
    public void queueSecondPass(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueSecondPass(r);
    }

    @Override
    public SkillCaster getCaster(AbstractEntity entity) {
        Optional<SkillCaster> caster;
        Optional<SkillCaster> maybeFurniture;
        if (entity.isPlayer()) {
            return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
        }
        if (entity instanceof VirtualEntity) {
            return new GenericCaster(entity);
        }
        ActiveMob maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (maybeMob != null) {
            return maybeMob;
        }
        if (((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().isPresent() && (maybeFurniture = ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().get().getFurnitureCaster(entity)).isPresent()) {
            return maybeFurniture.get();
        }
        if (this.skillCasterProvider != null && (caster = this.skillCasterProvider.getCaster(entity)).isPresent()) {
            return caster.get();
        }
        return new GenericCaster(entity);
    }

    public SkillCaster getCasterNullable(AbstractEntity entity) {
        Optional<SkillCaster> caster;
        if (entity.isPlayer()) {
            return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer());
        }
        ActiveMob maybeMob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity);
        if (maybeMob != null) {
            return maybeMob;
        }
        if (this.skillCasterProvider != null && (caster = this.skillCasterProvider.getCaster(entity)).isPresent()) {
            return caster.get();
        }
        return null;
    }

    @Override
    public void registerSkill(String internalName, Skill skill) {
        this.skills.put(internalName, skill);
    }

    @Override
    public Optional<Skill> getSkill(String internalName) {
        return this.getSkill(null, internalName);
    }

    @Override
    public Optional<Skill> getSkill(File file, String internalName) {
        return this.getSkill(file, null, internalName);
    }

    @Override
    public Optional<Skill> getSkill(File file, SkillHolder parent, String internalName) {
        if (internalName == null) {
            return Optional.empty();
        }
        if ((internalName = internalName.trim()).startsWith("[") && internalName.endsWith("]")) {
            internalName = internalName.substring(1, internalName.length() - 1);
            internalName = MythicLineConfigImpl.unparseBlock(internalName);
            String uncommentedLines = internalName.replaceAll("<#> *-.*?(?=<#>|-|$)", "");
            String[] split = uncommentedLines.split("-");
            List<String> elements = Arrays.stream(split).map(String::trim).filter(trim -> !trim.isEmpty()).collect(Collectors.toList());
            MetaSkill skill = new MetaSkill(this, file, elements);
            if (parent != null) {
                skill.addParent(parent);
                skill.setPack(parent.getPack());
            }
            skill.setInlineSkill(true);
            return Optional.of(skill);
        }
        if (this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    public Optional<Skill> getSkill(File file, Collection<String> elements) {
        MetaSkill skill = new MetaSkill(this, file, elements);
        String skillName = skill.getInternalName();
        this.skills.put(skillName, skill);
        skill.setInlineSkill(true);
        return Optional.of(skill);
    }

    public MetaSkillMechanic getWrappedSkill(File file, Collection<String> elements) {
        Optional<Skill> maybeSkill = this.getSkill(file, elements);
        Skill skill = maybeSkill.get();
        return new MetaSkillMechanic(this, file, skill);
    }

    @Override
    public Collection<String> getSkillNames() {
        return this.skills.keySet();
    }

    @Override
    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    public void setCasterProvider(SkillCasterProvider provider) {
        this.skillCasterProvider = provider;
    }

    public void runTimerSkills(long timer) {
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (am == null || am.getEntity() == null || am.getType() == null) continue;
            am.tick(timer, ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain());
            if (am.isDead() || am.getEntity() == null || !am.getEntity().isValid() || !am.getType().isUsingTimers()) continue;
            this.executeMobTimerSkills(am, timer);
            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "---- Executed TIMER skills", new Object[0]);
        }
    }

    public void runTimerSkillsFolia(long timer) {
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (am == null || am.getEntity() == null || am.getType() == null) continue;
            Schedulers.of(am.getEntity().getBukkitEntity()).run(() -> {
                am.tick(timer, ((MythicBukkit)this.getPlugin()).getConfiguration().getClockIntervalMain());
                if (!am.isDead() && am.getEntity() != null && am.getEntity().isValid() && am.getType().isUsingTimers()) {
                    this.executeMobTimerSkills(am, timer);
                    MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "---- Executed TIMER skills", new Object[0]);
                }
            });
        }
    }

    public void executeMobTimerSkills(ActiveMob am, long timer) {
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.TIMER, am, null);
        data.setPower(am.getPower());
        am.getType().executeTimerSkills(data, timer);
    }

    @Override
    public void setSkillCooldown(SkillCaster caster, AbstractSkill skill, double millis) {
        UUID casterId = caster.getEntity().getUniqueId();
        UUID skillId = skill.getUuid();
        if (millis > 0.0) {
            long expiresAt = System.currentTimeMillis() + (long)millis;
            COOLDOWNS.computeIfAbsent(casterId, k -> new ConcurrentHashMap()).put(skillId, expiresAt);
        } else {
            this.removeSkillCooldown(caster, skill);
        }
    }

    @Override
    public boolean isSkillOnCooldown(SkillCaster caster, AbstractSkill skill) {
        return this.getSkillCooldownRemainingMillis(caster, skill) > 0L;
    }

    @Override
    public void clearSkillCooldowns(SkillCaster caster) {
        UUID casterId = caster.getEntity().getUniqueId();
        COOLDOWNS.remove(casterId);
    }

    @Override
    public long getSkillCooldownRemainingMillis(SkillCaster caster, AbstractSkill skill) {
        UUID casterId = caster.getEntity().getUniqueId();
        UUID skillId = skill.getUuid();
        ConcurrentMap skills = (ConcurrentMap)COOLDOWNS.get(casterId);
        if (skills == null) {
            return 0L;
        }
        Long expiresAt = (Long)skills.get(skillId);
        if (expiresAt == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        if (now >= expiresAt) {
            this.removeSkillCooldown(caster, skill);
            return 0L;
        }
        return expiresAt - now;
    }

    @Override
    public void removeSkillCooldown(SkillCaster caster, AbstractSkill skill) {
        UUID casterId = caster.getEntity().getUniqueId();
        UUID skillId = skill.getUuid();
        ConcurrentMap skills = (ConcurrentMap)COOLDOWNS.get(casterId);
        if (skills != null) {
            skills.remove(skillId);
            if (skills.isEmpty()) {
                COOLDOWNS.remove(casterId, skills);
            }
        }
    }

    @Override
    public void purgeExpiredCooldowns() {
        long now = System.currentTimeMillis();
        for (Map.Entry entry : COOLDOWNS.entrySet()) {
            ConcurrentMap skills = (ConcurrentMap)entry.getValue();
            skills.entrySet().removeIf(e -> (Long)e.getValue() <= now);
            if (!skills.isEmpty()) continue;
            COOLDOWNS.remove(entry.getKey(), skills);
        }
    }

    public ImmutableMap<String, Class<? extends SkillMechanic>> getMechanics() {
        return ImmutableMap.copyOf(MECHANICS);
    }

    private static void loadMechanics() {
    }

    @Override
    public SkillMechanic getMechanic(String skill) {
        return this.getMechanic(null, skill);
    }

    public SkillMechanic getMechanic(File file, String skill) {
        return this.getMechanic(null, file, null, skill);
    }

    public SkillMechanic getMechanic(Pack pack, File file, SkillHolder parent, String skill) {
        SkillMechanic cached;
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Matching mechanic to string: {0}", skill);
        String[] s2 = skill.split(" ");
        String name = null;
        MythicLineConfigImpl mlc = file != null ? new MythicLineConfigImpl(file, s2[0]) : new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Matching MythicSkill type to {0}", name.toUpperCase());
        String cacheKey = null;
        if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents() && (cached = (SkillMechanic)this.mechanicCache.get(cacheKey = skill.trim())) != null) {
            return cached;
        }
        if (MECHANICS.containsKey(name.toUpperCase())) {
            Class<? extends SkillMechanic> clazz = MECHANICS.get(name.toUpperCase());
            try {
                SkillMechanic mechanic = clazz.getConstructor(SkillExecutor.class, File.class, String.class, MythicLineConfig.class).newInstance(this, file, skill, mlc);
                mechanic.setPack(pack);
                mechanic.setParent(parent);
                if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents() && cacheKey != null && mechanic.getCooldown() == null) {
                    this.mechanicCache.putIfAbsent(cacheKey, mechanic);
                }
                return mechanic;
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct mechanic {0}", skill);
                e.printStackTrace();
            }
        }
        try {
            if (name.toUpperCase().startsWith("SKILL:") || name.toUpperCase().startsWith("META:")) {
                String skillName = name.substring(name.indexOf(":") + 1);
                MetaSkillMechanic mechanic = new MetaSkillMechanic(this, file, skill, skillName, mlc);
                mechanic.setPack(pack);
                mechanic.setParent(parent);
                if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents() && cacheKey != null && mechanic.getCooldown() == null) {
                    this.mechanicCache.putIfAbsent(cacheKey, mechanic);
                }
                return mechanic;
            }
            CustomMechanic mechanic = new CustomMechanic(this, file, name.toUpperCase(), skill, mlc);
            mechanic.setPack(pack);
            mechanic.setParent(parent);
            return mechanic;
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to load skill line due to bad syntax: {0} ", skill);
            MythicLogger.handleMinorError(ex);
            return null;
        }
    }

    public File getSchematic(String schematicName) {
        String[] externalSchematicFolders;
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File schematicFolder = pack.getSchematicDirectory();
            File schematicFile = new File(schematicFolder, schematicName);
            if (!schematicFile.exists()) continue;
            return schematicFile;
        }
        File pluginsFolder = MythicBukkit.inst().getDataFolder().getParentFile();
        for (String externalFolder : externalSchematicFolders = new String[]{"FastAsyncWorldEdit", "WorldEdit"}) {
            File schematicFile = new File(pluginsFolder, externalFolder + "/schematics/" + schematicName);
            if (!schematicFile.exists()) continue;
            return schematicFile;
        }
        return null;
    }

    public ImmutableMap<String, Class<? extends SkillTargeter>> getTargeters() {
        return ImmutableMap.copyOf(TARGETERS);
    }

    @Override
    public SkillTargeter getTargeter(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicTargeter type to " + search, new Object[0]);
        ImmutableMap<String, Class<? extends SkillTargeter>> TARGETERS = ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeters();
        if (TARGETERS.containsKey(search.toUpperCase())) {
            Class clazz = (Class)TARGETERS.get(search.toUpperCase());
            try {
                return (SkillTargeter)clazz.getConstructor(SkillExecutor.class, MythicLineConfig.class).newInstance(this, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct targeter {0}", search);
                e.printStackTrace();
            }
        }
        if (search.substring(1, 2).equals("[")) {
            switch (search.substring(0, 1).toLowerCase()) {
                case "p": 
                case "r": 
                case "a": 
                case "e": {
                    return new VanillaTargeter(this, mlc, mlc.getLine());
                }
            }
        }
        return new CustomTargeter(this, search.toUpperCase(), mlc);
    }

    @Override
    public SkillTargeter getTargeter(String strTarget) {
        String search = strTarget.substring(1).trim();
        if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents() && this.targeterCache.containsKey(search)) {
            return (SkillTargeter)this.targeterCache.get(search);
        }
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTargeter {0}", search);
        SkillTargeter constructedTargeter = ((MythicBukkit)this.getPlugin()).getSkillManager().getTargeter(name, mlc);
        if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents()) {
            this.targeterCache.put(search, constructedTargeter);
        }
        return constructedTargeter;
    }

    @Override
    public SkillMetadata processTargets(SkillMetadata data, SkillTargeter targeter) {
        return this.processTargets(data, targeter, false, false);
    }

    @Override
    public SkillMetadata processTargets(SkillMetadata data, SkillTargeter targeter, boolean targetCreative, boolean splitPower) {
        CustomTargeter customTargeter;
        SkillCaster originalCaster = data.getCaster();
        SkillCaster skillCaster = data.getCaster();
        if (skillCaster instanceof ActiveMob) {
            ActiveMob activeCaster = (ActiveMob)skillCaster;
            if (targeter.isSudoParent()) {
                activeCaster.getParent().ifPresent(parent -> data.setCaster(((MythicBukkit)this.getPlugin()).getSkillManager().getCaster((AbstractEntity)parent)));
            }
            if (targeter.isSudoOwner()) {
                activeCaster.getOwnerUUID().ifPresent(owner -> {
                    AbstractEntity ownerEntity = MythicBukkit.inst().getBootstrap().getEntity((UUID)owner);
                    if (ownerEntity != null) {
                        data.setCaster(((MythicBukkit)this.getPlugin()).getSkillManager().getCaster(ownerEntity));
                    }
                });
            }
            if (targeter.isSudoTrigger() && data.getTrigger() != null) {
                data.setCaster(((MythicBukkit)this.getPlugin()).getSkillManager().getCaster(data.getTrigger()));
            }
        }
        if (targeter instanceof CustomTargeter && (customTargeter = (CustomTargeter)targeter).getTargeter().isPresent()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillTargeter is a CUSTOM targeter", new Object[0]);
            targeter = customTargeter.getTargeter().get();
        }
        if (targeter instanceof IEntitySelector) {
            IEntitySelector entitySelector = (IEntitySelector)targeter;
            try {
                data.setEntityTargets(entitySelector.getEntities(data));
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": EntityTargeter found {0} targets", data.getEntityTargets().size());
                entitySelector.filter(data, targetCreative);
            }
            catch (IllegalArgumentException ex) {
                data.setEntityTargets(Sets.newHashSet());
                MythicLogger.handleMinorError(ex);
            }
        } else if (targeter instanceof ILocationSelector) {
            ILocationSelector locationSelector = (ILocationSelector)targeter;
            data.setLocationTargets(locationSelector.getLocations(data));
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": LocationTargeter found {0} targets", data.getLocationTargets().size());
            locationSelector.filter(data);
        } else if (targeter instanceof ConsoleTargeter) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting console", new Object[0]);
            data.setEntityTargets(null);
            data.setLocationTargets(null);
            data.setConsoleTarget(true);
        }
        if (!data.hasTarget() && targeter.getFallback() != null) {
            return this.processTargets(data, targeter.getFallback(), targetCreative, splitPower);
        }
        if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty() && splitPower) {
            data.setPower(data.getPower() / (float)data.getEntityTargets().size());
        }
        if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty() && splitPower) {
            data.setPower(data.getPower() / (float)data.getLocationTargets().size());
        }
        data.setCaster(originalCaster);
        return data;
    }

    @Override
    public AbstractLocation getLocationTarget(SkillTargeter targeter, SkillMetadata data) {
        IEntityTargeter entityTargeter;
        AbstractEntity[] entities;
        Collection<AbstractLocation> locations;
        if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
            targeter = ((CustomTargeter)targeter).getTargeter().get();
        }
        AbstractLocation newOrigin = targeter instanceof ILocationSelector ? (!(locations = ((ILocationSelector)targeter).getLocations(data)).isEmpty() ? (AbstractLocation)locations.stream().collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
            Collections.shuffle(collected);
            return collected.stream();
        })).findFirst().get() : null) : (targeter instanceof TriggerLocationTargeter ? data.getTrigger().getLocation() : (targeter instanceof IEntityTargeter ? ((entities = (entityTargeter = (IEntityTargeter)((Object)targeter)).getEntities(data).toArray(new AbstractEntity[0])).length > 0 ? entities[0].getLocation() : null) : null));
        if (newOrigin == null && targeter.getFallback() != null) {
            return this.getLocationTarget(targeter.getFallback(), data);
        }
        return newOrigin;
    }

    public ImmutableMap<String, Class<? extends SkillCondition>> getConditions() {
        return ImmutableMap.copyOf(CONDITIONS);
    }

    @Override
    public SkillCondition getCondition(String condition) {
        condition = ((String)condition).trim();
        if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents() && this.conditionCache.containsKey(condition)) {
            return (SkillCondition)this.conditionCache.get(condition);
        }
        if (((String)condition).startsWith("(")) {
            try {
                CompositeCondition constructedCondition = new CompositeCondition(this, (String)condition);
                if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents()) {
                    this.conditionCache.put((String)condition, constructedCondition);
                }
                return constructedCondition;
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Failed to construct composite condition {0}", condition);
                ex.printStackTrace();
                return new InvalidCondition((String)condition);
            }
        }
        if (((String)(condition = MythicLineConfigImpl.unparseBlock((String)condition))).contains("}")) {
            String sp1 = ((String)condition).substring(0, ((String)condition).indexOf("}"));
            String sp2 = ((String)condition).substring(((String)condition).indexOf("}"));
            String ns = sp1.replace(" ", "") + sp2;
            condition = ns;
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, ": Normalized Condition string to: " + (String)condition, new Object[0]);
        }
        String[] s2 = ((String)condition).split(" ");
        String name = null;
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching MythicCondition type to " + name, new Object[0]);
        ImmutableMap<String, Class<? extends SkillCondition>> CONDITIONS = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions();
        if (CONDITIONS.containsKey(name.toUpperCase())) {
            Class clazz = (Class)CONDITIONS.get(name.toUpperCase());
            try {
                SkillCondition constructedCondition = (SkillCondition)clazz.getConstructor(String.class, MythicLineConfig.class).newInstance(condition, mlc);
                if (((MythicBukkit)this.getPlugin()).getConfiguration().isCacheComponents()) {
                    this.conditionCache.put((String)condition, constructedCondition);
                }
                return constructedCondition;
            }
            catch (Error | Exception ex) {
                MythicLogger.error("Failed to construct condition {0}", condition);
                ex.printStackTrace();
                return new InvalidCondition((String)condition);
            }
        }
        try {
            return new CustomCondition(name, (String)condition, mlc);
        }
        catch (Error | Exception ex) {
            MythicLogger.error("Failed to load condition '" + name + "'");
            ex.printStackTrace();
            return new InvalidCondition((String)condition);
        }
    }

    @Override
    public List<SkillCondition> getConditions(List<String> block) {
        ArrayList<SkillCondition> conditions = null;
        for (String s2 : block) {
            SkillCondition sc = this.getCondition(s2 = MythicLineConfigImpl.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            if (conditions == null) {
                conditions = new ArrayList<SkillCondition>();
            }
            conditions.add(sc);
        }
        return conditions;
    }

    @Override
    public List<SkillCondition> getConditions(String block) {
        if (block.startsWith("[") && block.endsWith("]")) {
            block = block.substring(1, block.length() - 1);
            block = MythicLineConfigImpl.unparseBlock(block);
            String[] split = block.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            return this.getConditions(elements);
        }
        return null;
    }

    public ImmutableMap<String, Class<? extends SkillAudience>> getAudiences() {
        return ImmutableMap.copyOf(AUDIENCES);
    }

    @Override
    public SkillAudience getAudience(String line) {
        if (line == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching Audience type to " + line, new Object[0]);
        MythicLineConfigImpl mlc = new MythicLineConfigImpl(line);
        if (line.startsWith("@")) {
            return new TargeterAudience(mlc, line);
        }
        String search = line.contains("{") ? line.substring(0, line.indexOf("{")) : line;
        ImmutableMap<String, Class<? extends SkillAudience>> AUDIENCES = ((MythicBukkit)this.getPlugin()).getSkillManager().getAudiences();
        if (AUDIENCES.containsKey(search.toUpperCase())) {
            Class clazz = (Class)AUDIENCES.get(search.toUpperCase());
            try {
                return (SkillAudience)clazz.getConstructor(MythicLineConfig.class).newInstance(mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct audience {0}", search);
                e.printStackTrace();
            }
        }
        return new CustomAudience(mlc);
    }

    private final void loadSkillComponents() {
        Collection<Class<?>> conditionsClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.conditions.all", MythicCondition.class);
        for (Class<?> clazz : conditionsClasses) {
            try {
                String string = clazz.getAnnotation(MythicCondition.class).name();
                String[] stringArray = clazz.getAnnotation(MythicCondition.class).aliases();
                if (!SkillCondition.class.isAssignableFrom(clazz)) continue;
                CONDITIONS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    CONDITIONS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load condition {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> mechanicsClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.mechanics", MythicMechanic.class);
        for (Class<?> clazz : mechanicsClasses) {
            try {
                String string = clazz.getAnnotation(MythicMechanic.class).name();
                String[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                if (!SkillMechanic.class.isAssignableFrom(clazz)) continue;
                MECHANICS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    MECHANICS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load mechanic {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> collection = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.targeters", MythicTargeter.class);
        for (Class<?> clazz : collection) {
            try {
                String name = clazz.getAnnotation(MythicTargeter.class).name();
                String[] aliases = clazz.getAnnotation(MythicTargeter.class).aliases();
                if (!SkillTargeter.class.isAssignableFrom(clazz)) continue;
                TARGETERS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    TARGETERS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load targeter {0}", clazz.getCanonicalName());
            }
        }
        Collection<Class<?>> collection2 = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.audience", MythicAudience.class);
        for (Class<?> clazz : collection2) {
            try {
                String name = clazz.getAnnotation(MythicAudience.class).name();
                String[] aliases = clazz.getAnnotation(MythicAudience.class).aliases();
                if (!SkillAudience.class.isAssignableFrom(clazz)) continue;
                AUDIENCES.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    AUDIENCES.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load audience {0}", clazz.getCanonicalName());
            }
        }
    }

    @Override
    public AuraExecutor getAuraManager() {
        return this.auraManager;
    }

    @Override
    public EventExecutor getEventBus() {
        return this.eventBus;
    }

    public CommandSkillExecutor getCommandSkillExecutor() {
        return this.commandSkillExecutor;
    }
}

