/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.IWaitableSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicSkillEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.CancelSkill;
import io.lumine.mythic.core.skills.mechanics.CustomMechanic;
import io.lumine.mythic.core.skills.mechanics.DelaySkill;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class MetaSkill
extends AbstractSkill
implements Skill {
    protected final File file;
    protected final String internalName;
    protected final MythicConfig config;
    protected final Collection<SkillHolder> parents = Lists.newArrayList();
    protected Map<String, SkillAction> actions = new HashMap<String, SkillAction>();
    protected SkillAction baseSkill = new SkillAction("Skill", new String[0]).register(this.actions);
    protected SkillAction failedConditionsSkill = new SkillAction("OnFailSkill", "FailedConditionsSkill").register(this.actions);
    protected SkillAction onCooldownSkill = new SkillAction("OnCooldownSkill", new String[0]).register(this.actions);
    protected boolean stopIfNoTargets = false;
    protected boolean inlineSkill = false;
    protected List<String> killMessages;

    public MetaSkill(SkillExecutor manager, Pack pack, File file, String name, MythicConfig mc) {
        super(manager, file);
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.pack = pack;
        this.file = file;
        this.internalName = name;
        this.config = mc;
        String cd2 = mc.getString("Cooldown", null);
        if (cd2 != null) {
            this.cooldown = PlaceholderDouble.of(cd2);
        }
        this.stopIfNoTargets = mc.getBoolean("CancelIfNoTargets", true);
        this.actions.forEach((id, action) -> {
            String maybeRedirect = mc.getString((String)id, null);
            if (maybeRedirect != null) {
                this.getManager().queueSecondPass(() -> action.setRedirect(this.getPlugin().getSkillManager().getSkill(file, this, maybeRedirect)));
            }
            mc.getStringList(id + "s").forEach(mechanic -> {
                mechanic = MythicLineConfigImpl.unparseBlock(mechanic);
                try {
                    SkillMechanic mechanicSkill = this.getPlugin().getSkillManager().getMechanic(pack, mc.getFile(), this, (String)mechanic);
                    if (mechanicSkill != null) {
                        mechanicSkill.setParent(this);
                        action.addMechanic(mechanicSkill);
                    }
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + mechanic + "'");
                }
            });
        });
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTarget == null) {
                this.conditionsTarget = new ArrayList();
            }
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTrigger == null) {
                this.conditionsTrigger = new ArrayList();
            }
            this.conditionsTrigger.add(sc);
        }
    }

    public MetaSkill(SkillExecutor manager, MobType mob, Pack pack, File file, String name, MythicConfig mc) {
        super(manager, file);
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.pack = pack;
        this.file = file;
        this.internalName = name;
        this.config = mc;
        String cd2 = mc.getString("Cooldown", null);
        if (cd2 != null) {
            this.cooldown = PlaceholderDouble.of(cd2);
        }
        this.stopIfNoTargets = mc.getBoolean("CancelIfNoTargets", true);
        this.actions.forEach((id, action) -> {
            String maybeRedirect = mc.getString((String)id, null);
            if (maybeRedirect != null) {
                if (maybeRedirect.startsWith("self:")) {
                    maybeRedirect = maybeRedirect.replace("self:", "mob:" + mob.getInternalName() + ":");
                }
                String mechanic2 = maybeRedirect;
                this.getManager().queueSecondPass(() -> action.setRedirect(this.getPlugin().getSkillManager().getSkill(file, this, mechanic2)));
            }
            mc.getStringList(id + "s").forEach(mechanic -> {
                if ((mechanic = MythicLineConfigImpl.unparseBlock(mechanic)).startsWith("selfskill:")) {
                    mechanic = mechanic.replace("selfskill:", "skill:mob:" + mob.getInternalName() + ":");
                }
                try {
                    SkillMechanic mechanicSkill = this.getPlugin().getSkillManager().getMechanic(pack, mc.getFile(), this, (String)mechanic);
                    if (mechanicSkill != null) {
                        mechanicSkill.setParent(this);
                        action.addMechanic(mechanicSkill);
                    }
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + mechanic + "'");
                }
            });
        });
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if (s2.contains("self:")) {
                s2 = s2.replace("self:", "mob:" + mob.getInternalName() + ":");
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if (s2.contains("self:")) {
                s2 = s2.replace("self:", "mob:" + mob.getInternalName() + ":");
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTarget == null) {
                this.conditionsTarget = new ArrayList();
            }
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if (s2.contains("self:")) {
                s2 = s2.replace("self:", "mob:" + mob.getInternalName() + ":");
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTrigger == null) {
                this.conditionsTrigger = new ArrayList();
            }
            this.conditionsTrigger.add(sc);
        }
    }

    public MetaSkill(SkillExecutor manager, File file, Collection<String> skillList) {
        super(manager, file);
        this.pack = ((MythicBukkit)manager.getPlugin()).getPackManager().getBasePack();
        this.file = file;
        this.internalName = "#\u03bb." + UUID.randomUUID().toString();
        this.config = null;
        this.cooldown = null;
        for (String s2 : skillList) {
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            SkillMechanic ms = null;
            try {
                ms = MythicBukkit.inst().getSkillManager().getMechanic(this.pack, file, this, s2);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            if (ms == null) continue;
            this.baseSkill.addMechanic(ms);
        }
    }

    @Override
    public void addParent(SkillHolder parent) {
        this.parents.add(parent);
    }

    @Override
    public boolean isUsable(SkillMetadata data) {
        return this.isUsable(data, null);
    }

    @Override
    public boolean isUsable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (skillCaster.isSkillOnCooldown(this)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Cooldown check failed.", new Object[0]);
            this.execute(this.onCooldownSkill, meta);
            return false;
        }
        if (this.conditionsTarget != null) {
            for (SkillCondition mc : this.conditionsTarget) {
                if (!mc.evaluateTargets(meta) && this.stopIfNoTargets) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (!mc.evaluateTrigger(meta)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TriggerConditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (!mc.evaluateCaster(meta)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Conditions failed.", new Object[0]);
                    mc.getOnFailSkill().ifPresent(s2 -> s2.execute(meta));
                    this.execute(this.failedConditionsSkill, meta);
                    return false;
                }
                mc.getOnPassSkill().ifPresent(s2 -> s2.execute(meta));
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill usable!", new Object[0]);
        return true;
    }

    @Override
    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadataImpl data = new SkillMetadataImpl(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    @Override
    public void execute(SkillMetadata data) {
        MythicSkillEvent event = Events.callAndReturn(new MythicSkillEvent(data, this));
        if (event.isCancelled()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Event cancelled.", new Object[0]);
            return;
        }
        ObjectArrayFIFOQueueCloneable<SkillMechanic> skillqueue = new ObjectArrayFIFOQueueCloneable<SkillMechanic>(this.baseSkill.getMechanics());
        try {
            this.baseSkill.executeRedirect(data);
            MetaSkill.execute(data, skillqueue);
        }
        catch (Exception ex) {
            MythicLogger.error("Couldn't execute skill '" + this.internalName + "': Enable debugging for a stack trace.");
            if (this.inlineSkill) {
                ArrayList<CallSite> inlineInfo = new ArrayList<CallSite>();
                if (this.file != null) {
                    inlineInfo.add((CallSite)((Object)("Filepath: " + this.file.getPath())));
                }
                if (this.baseSkill != null && !this.baseSkill.mechanics.isEmpty() && this.baseSkill.mechanics.get(0).getConfig() != null) {
                    inlineInfo.add((CallSite)((Object)("First Skill Line: " + this.baseSkill.mechanics.get(0).getConfig().getLine())));
                }
                if (!inlineInfo.isEmpty()) {
                    MythicLogger.error("Additional Inline Skill Information: ");
                    for (String string : inlineInfo) {
                        MythicLogger.error("  " + string);
                    }
                }
            }
            MythicLogger.handleMinorError(ex);
        }
        this.triggerCooldown(data);
    }

    public void execute(SkillAction action, SkillMetadata data) {
        ObjectArrayFIFOQueueCloneable<SkillMechanic> skillqueue = new ObjectArrayFIFOQueueCloneable<SkillMechanic>(action.getMechanics());
        try {
            action.executeRedirect(data);
            MetaSkill.execute(data, skillqueue);
        }
        catch (Exception ex) {
            MythicLogger.error("Couldn't execute " + action.getId() + " '" + this.internalName + "': Enable debugging for a stack trace.");
            MythicLogger.handleMinorError(ex);
        }
        if (action == this.baseSkill) {
            this.triggerCooldown(data);
        }
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (!skillqueue.isEmpty()) {
            ISkillMechanic iSkillMechanic;
            CustomMechanic cm;
            SkillMechanic mbs = skillqueue.poll();
            if (data.isTerminated()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Terminating SkillMechanic {0}.", mbs.getConfigLine());
                break;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", mbs.getConfigLine());
            if (mbs instanceof CancelSkill && mbs.isUsableFromSkill(data)) break;
            if (mbs instanceof DelaySkill) {
                DelaySkill delaySkill = (DelaySkill)mbs;
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                if (data.isAsync()) {
                    Schedulers.async().runLater(ds, delaySkill.getTicks(data));
                    break;
                }
                Schedulers.of(data.getCaster().getEntity().getBukkitEntity()).runLater(ds, delaySkill.getTicks(data));
                break;
            }
            if (mbs instanceof IWaitableSkill) {
                IWaitableSkill waitable = (IWaitableSkill)((Object)mbs);
                if (!mbs.isUsableFromSkill(data)) break;
                mbs.execute(data.deepClone());
                waitable.completableExecution(data.deepClone()).thenAccept(success -> {
                    if (success.booleanValue()) {
                        MetaSkill.execute(data, skillqueue);
                    }
                });
                break;
            }
            if (mbs instanceof CustomMechanic && (cm = (CustomMechanic)mbs).getMechanic().isPresent() && (iSkillMechanic = cm.getMechanic().get()) instanceof IWaitableSkill) {
                IWaitableSkill waitable = (IWaitableSkill)((Object)iSkillMechanic);
                if (!mbs.isUsableFromSkill(data)) break;
                mbs.execute(data.deepClone());
                waitable.completableExecution(data.deepClone()).thenAccept(success -> {
                    if (success.booleanValue()) {
                        MetaSkill.execute(data, skillqueue);
                    }
                });
                break;
            }
            if (!mbs.isUsableFromSkill(data)) continue;
            mbs.execute(data.deepClone());
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public MythicConfig getConfig() {
        return this.config;
    }

    @Override
    public Collection<SkillHolder> getParents() {
        return this.parents;
    }

    public SkillAction getBaseSkill() {
        return this.baseSkill;
    }

    @Override
    public boolean isInlineSkill() {
        return this.inlineSkill;
    }

    public void setInlineSkill(boolean inlineSkill) {
        this.inlineSkill = inlineSkill;
    }

    public static class SkillAction {
        private final String id;
        private final String[] aliases;
        private Optional<Skill> redirect = Optional.empty();
        private ObjectArrayFIFOQueueCloneable<SkillMechanic> mechanics = new ObjectArrayFIFOQueueCloneable();

        public SkillAction(String id, String ... aliases) {
            this.id = id;
            this.aliases = aliases;
        }

        public void executeRedirect(SkillMetadata meta) {
            this.redirect.ifPresent(skill -> skill.execute(meta));
        }

        public void addMechanic(SkillMechanic ms) {
            this.mechanics.add(ms);
        }

        public SkillAction register(Map<String, SkillAction> actions) {
            actions.put(this.id, this);
            for (String alias : this.aliases) {
                actions.put(alias, this);
            }
            return this;
        }

        public String getId() {
            return this.id;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public Optional<Skill> getRedirect() {
            return this.redirect;
        }

        public ObjectArrayFIFOQueueCloneable<SkillMechanic> getMechanics() {
            return this.mechanics;
        }

        public void setRedirect(Optional<Skill> redirect) {
            this.redirect = redirect;
        }

        public void setMechanics(ObjectArrayFIFOQueueCloneable<SkillMechanic> mechanics) {
            this.mechanics = mechanics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SkillAction)) {
                return false;
            }
            SkillAction other = (SkillAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAliases(), other.getAliases())) {
                return false;
            }
            Optional<Skill> this$redirect = this.getRedirect();
            Optional<Skill> other$redirect = other.getRedirect();
            if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
                return false;
            }
            ObjectArrayFIFOQueueCloneable<SkillMechanic> this$mechanics = this.getMechanics();
            ObjectArrayFIFOQueueCloneable<SkillMechanic> other$mechanics = other.getMechanics();
            return !(this$mechanics == null ? other$mechanics != null : !this$mechanics.equals(other$mechanics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SkillAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getAliases());
            Optional<Skill> $redirect = this.getRedirect();
            result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
            ObjectArrayFIFOQueueCloneable<SkillMechanic> $mechanics = this.getMechanics();
            result = result * 59 + ($mechanics == null ? 43 : $mechanics.hashCode());
            return result;
        }

        public String toString() {
            return "MetaSkill.SkillAction(id=" + this.getId() + ", aliases=" + Arrays.deepToString(this.getAliases()) + ", redirect=" + String.valueOf(this.getRedirect()) + ", mechanics=" + String.valueOf(this.getMechanics()) + ")";
        }
    }

    public static class ObjectArrayFIFOQueueCloneable<K>
    extends ObjectArrayFIFOQueue<K>
    implements Queue<K>,
    Cloneable {
        public ObjectArrayFIFOQueueCloneable() {
        }

        public ObjectArrayFIFOQueueCloneable(int size) {
            super(size);
        }

        public ObjectArrayFIFOQueueCloneable(ObjectArrayFIFOQueueCloneable<K> queue) {
            super(queue.length);
            this.start = queue.start;
            this.end = queue.end;
            System.arraycopy(queue.array, 0, this.array, 0, this.end - this.start);
        }

        @Override
        public boolean contains(Object o) {
            for (int i = this.start; i < this.end; ++i) {
                if (!this.array[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return Arrays.asList(Arrays.copyOfRange(this.array, this.start, this.end)).iterator();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            return Arrays.copyOf(this.array, this.end - this.start, a.getClass());
        }

        @Override
        public boolean add(K k) {
            this.enqueue(k);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            for (int i = this.start; i < this.end; ++i) {
                if (!this.array[i].equals(o)) continue;
                System.arraycopy(this.array, i + 1, this.array, i, this.end - i - 1);
                --this.end;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> c) {
            for (K k : c) {
                this.enqueue(k);
            }
            return true;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            boolean changed = false;
            for (Object o : c) {
                changed |= this.remove(o);
            }
            return changed;
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            boolean changed = false;
            for (int i = this.start; i < this.end; ++i) {
                if (c.contains(this.array[i])) continue;
                this.remove(this.array[i]);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean offer(K k) {
            this.enqueue(k);
            return true;
        }

        @Override
        public K remove() {
            return (K)this.dequeue();
        }

        @Override
        public K poll() {
            if (this.start == this.end) {
                return null;
            }
            return (K)this.dequeue();
        }

        @Override
        public K element() {
            return (K)this.first();
        }

        @Override
        public K peek() {
            if (this.start == this.end) {
                return null;
            }
            return (K)this.array[this.start];
        }

        public K get(int index) {
            if (index < 0 || index >= this.size()) {
                return null;
            }
            return (K)this.array[index];
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty();
        }

        public ObjectArrayFIFOQueueCloneable<K> clone() {
            return new ObjectArrayFIFOQueueCloneable<K>(this);
        }
    }
}

