/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.totems;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.mobs.MobManager;
import io.lumine.mythic.api.mobs.NPCManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.mobs.MobType;
import io.lumine.mythic.core.mobs.totems.TotemConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.BlockPlaceEvent;

public class TotemExecutor
extends ReloadableModule<MythicBukkit>
implements NPCManager {
    private final Map<Material, Collection<TotemConfig>> mobTotems = Maps.newConcurrentMap();

    public TotemExecutor(MythicBukkit plugin, MobManager mobManager) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit mythicBukkit) {
        Events.subscribe(BlockPlaceEvent.class).handler(event -> Schedulers.of((Entity)event.getPlayer()).runLater(() -> this.onBlockPlace((BlockPlaceEvent)event), 5L)).bindWith(this);
    }

    @Override
    public void unload() {
        this.mobTotems.clear();
    }

    public void registerTotem(MobType mobType) {
        TotemConfig totemConfig = mobType.getTotemConfig();
        if (totemConfig == null) {
            return;
        }
        Material material = totemConfig.getTriggerBlock().getBlockData().getMaterial();
        this.mobTotems.putIfAbsent(material, new ArrayList());
        this.mobTotems.get(material).add(totemConfig);
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        Material material = event.getBlock().getType();
        Collection<TotemConfig> totems = this.mobTotems.get(material);
        if (totems == null || totems.isEmpty()) {
            return;
        }
        Block placedBlock = event.getBlockPlaced();
        Schedulers.async().run(() -> {
            for (TotemConfig totem : totems) {
                BukkitBlock bukkitBlock;
                AbstractBlock patt0$temp = totem.getTriggerBlock();
                if ((!(patt0$temp instanceof BukkitBlock) ? !totem.getTriggerBlock().matches(BukkitAdapter.adapt(placedBlock.getLocation())) : !(bukkitBlock = (BukkitBlock)patt0$temp).matches(placedBlock)) || !totem.isValidTotemStructure(placedBlock)) continue;
                Schedulers.of((Entity)event.getPlayer()).run(() -> {
                    totem.summonMob(placedBlock);
                    totem.replacePattern(placedBlock);
                });
                break;
            }
        });
    }
}

