/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs.equipment;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.core.constants.MobKeys;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;

public class MobEquipment
implements StatSource {
    private ItemStack itemStack;
    private EquipSlot equippedSlot;
    private Map<StatType, Map<StatModifierType, Double>> stats;

    public MobEquipment(ActiveMob activeMob, ItemStack item, EquipSlot equippedSlot, MobEquipment previousItem) {
        block9: {
            block7: {
                block8: {
                    this.stats = Maps.newConcurrentMap();
                    if (!item.hasItemMeta()) break block7;
                    ItemMeta itemMeta = item.getItemMeta();
                    PersistentDataContainer data = itemMeta.getPersistentDataContainer();
                    if (!data.has(MobKeys.STATS, MobKeys.STAT_FIELD_ITEMS)) break block8;
                    HashMap stats = (HashMap)data.get(MobKeys.STATS, MobKeys.STAT_FIELD_ITEMS);
                    Map<StatType, Map<StatModifierType, Double>> previousStats = previousItem == null || previousItem.getStats().isEmpty() ? null : previousItem.getStats();
                    for (Map.Entry statEntry : stats.entrySet()) {
                        String statName = (String)statEntry.getKey();
                        Optional<StatType> maybeStat = MythicProvider.get().getStatManager().getStat(statName);
                        if (maybeStat.isEmpty()) continue;
                        StatType statType = maybeStat.get();
                        if (previousStats != null && previousStats.containsKey(statType)) {
                            previousItem.getStats().remove(statType);
                            activeMob.getStatRegistry().removeValueSilently(statType, previousItem);
                        }
                        Map statMap = this.stats.compute(statType, (x, y) -> Maps.newHashMap());
                        for (Map.Entry valueEntry : ((HashMap)statEntry.getValue()).entrySet()) {
                            StatModifierType operation = StatModifierType.valueOf((String)valueEntry.getKey());
                            statMap.put(operation, (Double)valueEntry.getValue());
                            activeMob.getStatRegistry().putValueSilently(statType, this, operation, (Double)valueEntry.getValue());
                        }
                        this.stats.put(statType, statMap);
                    }
                    if (previousStats == null) break block9;
                    for (StatType stat : previousStats.keySet()) {
                        activeMob.getStatRegistry().removeValueSilently(stat, previousItem);
                    }
                    break block9;
                }
                if (previousItem == null || !previousItem.hasStats()) break block9;
                for (StatType stat : previousItem.getStats().keySet()) {
                    activeMob.getStatRegistry().removeValueSilently(stat, previousItem);
                }
                break block9;
            }
            if (previousItem != null && previousItem.hasStats()) {
                for (StatType stat : previousItem.getStats().keySet()) {
                    activeMob.getStatRegistry().removeValueSilently(stat, previousItem);
                }
            }
        }
    }

    public boolean hasStats() {
        return !this.stats.isEmpty();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public EquipSlot getEquippedSlot() {
        return this.equippedSlot;
    }

    public Map<StatType, Map<StatModifierType, Double>> getStats() {
        return this.stats;
    }
}

