/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.collect.Maps;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class MobRegistry
implements Terminable {
    private transient Map<UUID, ActiveMob> activeMobs = Maps.newConcurrentMap();

    @Override
    public void close() {
        this.activeMobs.values().removeIf(mob -> mob.getType().getDespawnMode().getDespawnsOnUnload());
        this.activeMobs.values().forEach(mob -> mob.getVariables().unload());
    }

    public boolean isActiveMob(UUID uuid) {
        if (this.activeMobs.containsKey(uuid)) {
            if (this.activeMobs.get(uuid).getType() != null) {
                return true;
            }
            this.activeMobs.remove(uuid);
        }
        return false;
    }

    public Optional<ActiveMob> getActiveMob(UUID uuid) {
        if (this.isActiveMob(uuid)) {
            return Optional.ofNullable(this.activeMobs.getOrDefault(uuid, null));
        }
        return Optional.empty();
    }

    public Collection<ActiveMob> values() {
        return this.activeMobs.values();
    }

    public void put(UUID uuid, ActiveMob mob) {
        this.activeMobs.put(uuid, mob);
    }

    public void setInactive(UUID uuid) {
        this.activeMobs.remove(uuid);
    }

    public void removeMob(UUID uuid) {
        this.activeMobs.remove(uuid);
    }

    public ActiveMob get(UUID uniqueId) {
        if (this.isActiveMob(uniqueId)) {
            return this.activeMobs.get(uniqueId);
        }
        return null;
    }
}

