/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.spawners;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.spawners.SpawnerBrowseMode;
import io.lumine.mythic.core.menus.spawners.SpawnerMenuContext;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnerBrowseMenu
extends MythicMenu<SpawnerMenuContext> {
    public SpawnerBrowseMenu(MythicBukkit plugin, MenuManager manager) {
        super(plugin, manager, "/menus/spawner-browser.yml");
    }

    public void open(Player player) {
        this.open(player, new SpawnerMenuContext());
    }

    @Override
    public void open(Player player, SpawnerMenuContext context) {
        ArrayList spawners = Lists.newArrayList(this.getPlugin().getSpawnerManager().getSpawners());
        if (context.hasFilter()) {
            this.getPlugin().getSpawnerManager().filterSpawners(spawners, context.getFilter());
        }
        if (context.getMode() == SpawnerBrowseMode.ALPHABETICAL) {
            Collections.sort(spawners, (i1, i2) -> i1.getInternalName().compareToIgnoreCase(i2.getInternalName()));
        } else if (context.getMode() == SpawnerBrowseMode.DISTANCE) {
            AbstractLocation base = BukkitAdapter.adapt(player.getLocation());
            Collections.sort(spawners, (i1, i2) -> {
                if (!base.getWorld().getName().equals(i1.getLocation().getWorld())) {
                    return -1;
                }
                double d1 = base.distanceSquared(i1.getLocation());
                return i1.getInternalName().compareToIgnoreCase(i2.getInternalName());
            });
        }
        this.getPlugin().getMenuManager().getSpawnerBrowseMenu().open(player, context, spawners);
    }

    @Override
    public EditableMenuBuilder<SpawnerMenuContext> build(EditableMenuBuilder<SpawnerMenuContext> builder) {
        builder = this.addPageButtons(builder);
        builder.getIcon("BACK_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> this.getMenuManager().getMainMenu().open((Player)player, player)));
        builder.getIcon("VIEW_BUTTON").ifPresent(icon -> icon.getBuilder().lore(context -> Lists.newArrayList((Object[])new String[]{"<gold>Current View<white>: <yellow>" + String.valueOf((Object)context.getMode())})).click((context, player) -> {
            context.setMode(context.getMode().next());
            this.open((Player)player, (SpawnerMenuContext)context);
        }));
        builder.getIcon("FILTER_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            player.closeInventory();
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the text you'd like to search for:", "<gray>Type cancel to abort filtering.");
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                context.setFilter(input);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> this.open((Player)player, (SpawnerMenuContext)context));
        }));
        builder.getIcon("FILTER_RESET_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            context.clearFilter();
            this.open((Player)player, (SpawnerMenuContext)context);
        }));
        return builder;
    }
}

