/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.mobs.MobEditorButton;
import io.lumine.mythic.core.menus.mobs.MobEditorButtons;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditDisplayButton
extends MobEditorButton {
    public EditDisplayButton(MobEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<MobEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.NAME_TAG).name("<green>Set Display Name").lore(context -> Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>" + String.valueOf(context.getMob().getDisplayName())})).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Display Name you'd like to use.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                MythicMob editing = context.getMob();
                editing.setDisplayName(PlaceholderString.of(input));
                editing.getConfig().setSave("Display", input);
                editing.buildCache();
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).build();
    }
}

