/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.items.ItemEditorButton;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditMaterialButton
extends ItemEditorButton {
    public EditMaterialButton(ItemEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<ItemEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.GRASS_BLOCK).name("<green>Set Material").lore(context -> Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>" + String.valueOf(context.getItem().getMaterial())})).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the item type (Material) you'd like to use.", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                if (!context.getItem().setMaterial(input)) {
                    CommandHelper.sendError((CommandSender)player, "Failed to set material: invalid material specified.");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).build();
    }
}

