/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.custom.icons;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.core.menus.custom.CustomMenuContext;
import io.lumine.mythic.core.menus.custom.icons.IconLoreParser;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplate;
import java.util.List;

public class IconTemplate {
    private PlaceholderString display;
    private IconLoreTemplate tooltip;

    public IconTemplate(MythicConfig config, IconLoreParser parser) {
        this.display = config.getPlaceholderString("Display");
        List<String> tooltipLines = config.getStringList("Lore");
        this.tooltip = new IconLoreTemplate(parser, tooltipLines);
    }

    public IconBuilder<CustomMenuContext> apply(CustomMenuContext context, IconBuilder<CustomMenuContext> icon) {
        if (this.display != null) {
            icon.name(this.display.get(context));
        }
        if (this.tooltip != null) {
            this.tooltip.apply(context, icon);
        }
        return icon;
    }

    public PlaceholderString getDisplay() {
        return this.display;
    }

    public IconLoreTemplate getTooltip() {
        return this.tooltip;
    }

    public void setDisplay(PlaceholderString display) {
        this.display = display;
    }

    public void setTooltip(IconLoreTemplate tooltip) {
        this.tooltip = tooltip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IconTemplate)) {
            return false;
        }
        IconTemplate other = (IconTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderString this$display = this.getDisplay();
        PlaceholderString other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        IconLoreTemplate this$tooltip = this.getTooltip();
        IconLoreTemplate other$tooltip = other.getTooltip();
        return !(this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IconTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderString $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        IconLoreTemplate $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        return result;
    }

    public String toString() {
        return "IconTemplate(display=" + String.valueOf(this.getDisplay()) + ", tooltip=" + String.valueOf(this.getTooltip()) + ")";
    }
}

