/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.custom.icons;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.menus.custom.CustomMenuContext;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplate;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplateLine;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplateMultiLine;
import io.lumine.mythic.core.menus.custom.icons.IconLoreTemplateSingleLine;
import io.lumine.mythic.core.skills.SkillCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class IconLoreSection {
    private IconLoreTemplate template;
    private Collection<SkillCondition> conditions;
    private Collection<IconLoreTemplateLine> lines = Lists.newArrayList();
    private boolean filler = false;

    public IconLoreSection(IconLoreTemplate template, List<String> input) {
        this.template = template;
        for (String line : input) {
            this.parseLine(line);
        }
    }

    public IconLoreSection(IconLoreTemplate template, Map<?, ?> in) {
        Object line;
        this.template = template;
        if (in.containsKey("Conditions")) {
            this.conditions = Lists.newArrayList();
            List conditions = (List)in.get("Conditions");
            for (String line2 : conditions) {
                SkillCondition condition = MythicBukkit.inst().getSkillManager().getCondition(line2);
                this.conditions.add(condition);
            }
        }
        if (in.containsKey("Line")) {
            line = in.get("Line");
        } else if (in.containsKey("Filler")) {
            line = in.get("Filler");
        } else {
            return;
        }
        if (line instanceof String) {
            String stringLine = (String)line;
            this.parseLine(stringLine);
        } else if (line instanceof List) {
            List list = (List)line;
            for (String listLine : list) {
                this.parseLine(listLine);
            }
        }
    }

    private void parseLine(String line) {
        this.lines.add(this.template.parseLine(line));
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public Collection<String> parse(CustomMenuContext context) {
        ArrayList lore = Lists.newArrayList();
        for (IconLoreTemplateLine loreLine : this.lines) {
            IconLoreTemplateSingleLine loreTemplateSingleLine;
            String line;
            if (!loreLine.isApplicable(context)) continue;
            if (loreLine instanceof IconLoreTemplateMultiLine) {
                IconLoreTemplateMultiLine loreTemplateMultiLine = (IconLoreTemplateMultiLine)loreLine;
                List<String> lines = loreTemplateMultiLine.getLine(context);
                if (lines == null) continue;
                for (String line2 : lines) {
                    lore.add(line2);
                }
                continue;
            }
            if (!(loreLine instanceof IconLoreTemplateSingleLine) || (line = (loreTemplateSingleLine = (IconLoreTemplateSingleLine)loreLine).getLine(context)) == null) continue;
            lore.add(line);
        }
        return lore;
    }

    public IconLoreTemplate getTemplate() {
        return this.template;
    }

    public Collection<SkillCondition> getConditions() {
        return this.conditions;
    }

    public boolean isFiller() {
        return this.filler;
    }

    public void setFiller(boolean filler) {
        this.filler = filler;
    }
}

