/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.compatibility.CrucibleSupport;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.OptionalInt;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public interface Iconable {
    private static MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public String getDisplayName();

    public Collection<String> getDescription();

    public Pack getPack();

    public static ItemFactory get(Iconable iconable, MythicConfig config) {
        ItemFactory icon;
        CompatibilityManager compatManager = MythicBukkit.inst().getCompatibility();
        Material iconMaterial = Iconable.getPlugin().getConfiguration().getMenuIconGenerationMaterial();
        int iconModel = 0;
        try {
            icon = ItemFactory.of(iconMaterial);
        }
        catch (IllegalArgumentException ex) {
            icon = ItemFactory.of(Material.PAPER);
        }
        if (config.isSet("Icon")) {
            if (config.isConfigurationSection("Icon")) {
                if (config.isSet("Icon.Item")) {
                    String itemConfig = config.getString("Icon.Item", iconMaterial.toString());
                    AbstractItemStack aItem = MythicProvider.get().getBootstrap().createItem(itemConfig);
                    ItemStack bukkitItem = BukkitAdapter.adapt(aItem);
                    icon = ItemFactory.of(bukkitItem);
                }
                if (config.isSet("Icon.Material")) {
                    String itemMaterialConfig = config.getString("Icon.Material", iconMaterial.toString());
                    iconMaterial = Material.valueOf((String)itemMaterialConfig);
                    icon.type(iconMaterial);
                }
                if (config.isSet("Icon.Model")) {
                    String model = config.getString("Icon.Model");
                    OptionalInt maybeNumber = Numbers.parseInteger(model);
                    if (maybeNumber.isPresent()) {
                        iconModel = maybeNumber.getAsInt();
                        icon.customModelData(maybeNumber.getAsInt());
                    } else if (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                        CrucibleSupport.ItemGenerationFeedback generationFeedback = MythicBukkit.inst().getCompatibility().getCrucible().get().addItemToGeneration(iconable.getPack(), model);
                        if (generationFeedback.getItemModel().isPresent()) {
                            NamespacedKey itemModelKey = generationFeedback.getItemModel().get();
                            icon.itemModel(itemModelKey);
                        }
                    } else {
                        icon.itemModel(NamespacedKey.fromString((String)model));
                    }
                } else {
                    iconModel = Iconable.getPlugin().getConfiguration().getIconGenerationModel();
                    icon.model(iconModel);
                }
                if (config.isSet("Icon.Generation")) {
                    if (compatManager.getCrucible().isPresent()) {
                        compatManager.getCrucible().get().addItemToGeneration(iconable.getPack(), iconMaterial, iconModel, config.getNestedConfig("Icon"));
                    } else {
                        MythicLogger.error("Spell Icon pack generation requires Crucible.");
                    }
                }
            } else {
                String model = config.getString("Icon");
                OptionalInt maybeNumber = Numbers.parseInteger(model);
                if (maybeNumber.isPresent()) {
                    icon.model(maybeNumber.getAsInt());
                    iconModel = Iconable.getPlugin().getConfiguration().getIconGenerationModel();
                    if (compatManager.getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                        compatManager.getCrucible().get().addItemToGeneration(iconable.getPack(), iconMaterial, iconModel, config.getNestedConfig("Icon"));
                    } else {
                        MythicLogger.error("Spell Icon pack generation requires Crucible.");
                    }
                } else if (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                    CrucibleSupport.ItemGenerationFeedback generationFeedback = MythicBukkit.inst().getCompatibility().getCrucible().get().addItemToGeneration(iconable.getPack(), model);
                    if (generationFeedback.getItemModel().isPresent()) {
                        NamespacedKey itemModelKey = generationFeedback.getItemModel().get();
                        icon.itemModel(itemModelKey);
                    }
                } else {
                    icon.itemModel(NamespacedKey.fromString((String)model));
                }
            }
        }
        icon.name(iconable.getDisplayName());
        icon.lore(iconable.getDescription());
        return icon;
    }

    public static ItemFactory get(Iconable iconable, MythicConfig config, ItemFactory icon) {
        CompatibilityManager compatManager = MythicBukkit.inst().getCompatibility();
        if (config.isSet("Icon")) {
            if (config.isConfigurationSection("Icon")) {
                if (config.isSet("Icon.Item")) {
                    String itemConfig = config.getString("Icon.Item");
                    AbstractItemStack aItem = MythicProvider.get().getBootstrap().createItem(itemConfig);
                    ItemStack bukkitItem = BukkitAdapter.adapt(aItem);
                    icon = ItemFactory.of(bukkitItem);
                }
                if (config.isSet("Icon.Material")) {
                    String itemMaterialConfig = config.getString("Icon.Material");
                    Material iconMaterial = Material.valueOf((String)itemMaterialConfig);
                    icon.type(iconMaterial);
                }
                if (config.isSet("Icon.Model")) {
                    String model = config.getString("Icon.Model");
                    OptionalInt maybeNumber = Numbers.parseInteger(model);
                    if (maybeNumber.isPresent()) {
                        icon.customModelData(maybeNumber.getAsInt());
                    } else if (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                        CrucibleSupport.ItemGenerationFeedback generationFeedback = MythicBukkit.inst().getCompatibility().getCrucible().get().addItemToGeneration(iconable.getPack(), model);
                        if (generationFeedback.getItemModel().isPresent()) {
                            NamespacedKey itemModelKey = generationFeedback.getItemModel().get();
                            icon.itemModel(itemModelKey);
                        }
                    } else {
                        icon.itemModel(NamespacedKey.fromString((String)model));
                    }
                } else {
                    int iconModel = Iconable.getPlugin().getConfiguration().getIconGenerationModel();
                    icon.model(iconModel);
                }
                if (config.isSet("Icon.Generation")) {
                    if (compatManager.getCrucible().isPresent()) {
                        compatManager.getCrucible().get().addItemToGeneration(iconable.getPack(), icon.peek().getType(), icon.peek().getItemMeta().getCustomModelData(), config.getNestedConfig("Icon"));
                    } else {
                        MythicLogger.error("Spell Icon pack generation requires Crucible.");
                    }
                }
            } else {
                String model = config.getString("Icon");
                OptionalInt maybeNumber = Numbers.parseInteger(model);
                if (maybeNumber.isPresent()) {
                    icon.model(maybeNumber.getAsInt());
                    if (compatManager.getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                        compatManager.getCrucible().get().addItemToGeneration(iconable.getPack(), icon.peek().getType(), maybeNumber.getAsInt(), config.getNestedConfig("Icon"));
                    } else {
                        MythicLogger.error("Spell Icon pack generation requires Crucible.");
                    }
                } else if (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isImplicitlyGenerating()) {
                    CrucibleSupport.ItemGenerationFeedback generationFeedback = MythicBukkit.inst().getCompatibility().getCrucible().get().addItemToGeneration(iconable.getPack(), model);
                    if (generationFeedback.getItemModel().isPresent()) {
                        NamespacedKey itemModelKey = generationFeedback.getItemModel().get();
                        icon.itemModel(itemModelKey);
                    }
                } else {
                    icon.itemModel(NamespacedKey.fromString((String)model));
                }
            }
        }
        icon.name(iconable.getDisplayName());
        icon.lore(iconable.getDescription());
        return icon;
    }
}

