/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.EquipmentSlot;

public abstract class EquipSlot {
    public static final EquipSlot HEAD = new EquipSlot("HEAD", EquipmentSlot.HEAD, new String[]{"HELMET", "HELM", "HAT"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemHead(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemHead();
        }
    };
    public static final EquipSlot CHEST = new EquipSlot("CHEST", EquipmentSlot.CHEST, new String[]{"CHESTPIECE", "CHESTPLATE", "BODY"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemChest(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemChest();
        }
    };
    public static final EquipSlot LEGS = new EquipSlot("LEGS", EquipmentSlot.LEGS, new String[]{"LEGGINGS", "PANTS"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemLegs(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemLegs();
        }
    };
    public static final EquipSlot FEET = new EquipSlot("FEET", EquipmentSlot.FEET, new String[]{"BOOTS", "SHOES"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemFeet(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemFeet();
        }
    };
    public static final EquipSlot HAND = new EquipSlot("HAND", EquipmentSlot.HAND, new String[]{"WEAPON", "MAINHAND"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemMainHand(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemMainHand();
        }
    };
    public static final EquipSlot OFFHAND = new EquipSlot("OFFHAND", EquipmentSlot.OFF_HAND, new String[]{"SHIELD"}){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
            entity.equipItemOffHand(item);
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return entity.getItemOffhand();
        }
    };
    public static final EquipSlot NONE = new EquipSlot(null, null, new String[0]){

        @Override
        public void equip(AbstractEntity entity, AbstractItemStack item) {
        }

        @Override
        public Optional<AbstractItemStack> get(AbstractEntity entity) {
            return Optional.empty();
        }
    };
    private static final Map<String, EquipSlot> slots = new ConcurrentHashMap<String, EquipSlot>();
    private final String slot;
    private final EquipmentSlot bukkitSlot;
    private final String[] aliases;
    private final String slotToCheck;
    private final Collection<String> slotAliases = new HashSet<String>();

    public EquipSlot(String slotNBT, EquipmentSlot bukkitSlot, String ... aliases) {
        this(slotNBT, slotNBT, bukkitSlot, aliases);
    }

    public EquipSlot(String slotNBT, String slotToCheck, EquipmentSlot bukkitSlot, String ... aliases) {
        this.slot = slotNBT;
        this.bukkitSlot = bukkitSlot;
        this.aliases = aliases;
        this.slotToCheck = slotToCheck;
    }

    public void register() {
        if (this.slot == null) {
            return;
        }
        slots.put(this.slot, this);
        this.slotAliases.add(this.slot);
        for (String alias : this.aliases) {
            slots.put(alias, this);
            this.slotAliases.add(alias);
        }
    }

    public void unregister() {
        if (this.slot == null) {
            return;
        }
        slots.remove(this.slot);
        this.slotAliases.remove(this.slot);
        for (String alias : this.aliases) {
            slots.remove(alias);
            this.slotAliases.remove(alias);
        }
    }

    public boolean matches(String slot) {
        for (String alias : this.slotAliases) {
            if (!alias.equalsIgnoreCase(slot)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.slot;
    }

    public abstract void equip(AbstractEntity var1, AbstractItemStack var2);

    public abstract Optional<AbstractItemStack> get(AbstractEntity var1);

    public static Collection<EquipSlot> values() {
        return slots.values();
    }

    public static boolean isEquipSlot(String key) {
        for (EquipSlot slot : EquipSlot.values()) {
            if (!slot.matches(key)) continue;
            return true;
        }
        return false;
    }

    public static EquipSlot of(String key) {
        for (EquipSlot slot : EquipSlot.values()) {
            if (!slot.matches(key)) continue;
            return slot;
        }
        return NONE;
    }

    public String getSlot() {
        return this.slot;
    }

    public EquipmentSlot getBukkitSlot() {
        return this.bukkitSlot;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getSlotToCheck() {
        return this.slotToCheck;
    }

    static {
        HEAD.register();
        CHEST.register();
        LEGS.register();
        FEET.register();
        HAND.register();
        OFFHAND.register();
        NONE.register();
    }
}

