/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.ICommandDrop;
import io.lumine.mythic.api.drops.IMultiDrop;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.collections.WeightedCollection;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.numbers.RandomDouble;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropExecutor;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.InvalidDrop;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import java.util.Collection;
import java.util.List;

public class DropTable {
    private final MythicBukkit plugin;
    private final DropExecutor manager;
    private final String fileName;
    private final String internalName;
    private final MythicConfig config;
    protected List<SkillCondition> conditions = Lists.newArrayList();
    protected List<SkillCondition> conditionsTrigger = Lists.newArrayList();
    private WeightedCollection<Drop> drops = new WeightedCollection();
    private int minItems = -1;
    private int maxItems = -1;
    private RandomDouble bonusLevelItems = new RandomDouble("0");
    private RandomDouble bonusLuckItems = new RandomDouble("0");
    private boolean hasConditions = false;

    public DropTable(String file, String name, MythicConfig mc) {
        this(MythicBukkit.inst().getDropManager(), file, name, mc);
    }

    public DropTable(DropExecutor manager, String file, String name, MythicConfig mc) {
        SkillCondition sc;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.config = mc;
        this.fileName = file;
        this.internalName = name;
        int totalItems = mc.getInteger("TotalItems", -1);
        this.maxItems = mc.getInteger("MaxItems", totalItems);
        this.minItems = mc.getInteger("MinItems", totalItems);
        this.bonusLevelItems = new RandomDouble(mc.getString("BonusLevelItems", "0"));
        this.bonusLuckItems = new RandomDouble(mc.getString("BonusLuckItems", "0"));
        List<String> strDrops = mc.getStringList("Drops");
        manager.queueSecondPass(() -> {
            for (String s2 : strDrops) {
                Drop drop = manager.getDrop(file, s2 = MythicLineConfigImpl.unparseBlock(s2));
                if (drop instanceof InvalidDrop) continue;
                this.drops.add(drop);
            }
        });
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            sc = this.getPlugin().getSkillManager().getCondition(s2);
            if (sc instanceof InvalidCondition) continue;
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            sc = this.getPlugin().getSkillManager().getCondition(s2);
            if (sc instanceof InvalidCondition) continue;
            this.conditionsTrigger.add(sc);
        }
    }

    public DropTable(String file, String name, List<String> drops) {
        this(MythicBukkit.inst().getDropManager(), file, name, drops, false);
    }

    public DropTable(DropExecutor manager, String file, String name, List<String> drops) {
        this(manager, file, name, drops, false);
    }

    public DropTable(String file, String name, List<String> drops, boolean delayed) {
        this(MythicBukkit.inst().getDropManager(), file, name, drops, delayed);
    }

    public DropTable(DropExecutor manager, String file, String name, List<String> drops, boolean delayed) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.config = null;
        this.fileName = file;
        this.internalName = name;
        if (delayed) {
            manager.queueSecondPass(() -> {
                for (String s2 : drops) {
                    Drop drop = manager.getDrop(file, s2 = MythicLineConfigImpl.unparseBlock(s2));
                    if (drop instanceof InvalidDrop) continue;
                    this.drops.add(drop);
                }
            });
        } else {
            for (String s2 : drops) {
                Drop drop = manager.getDrop(file, s2 = MythicLineConfigImpl.unparseBlock(s2));
                if (drop instanceof InvalidDrop) continue;
                this.drops.add(drop);
            }
        }
    }

    public boolean hasDrops() {
        return this.drops.size() > 0;
    }

    public LootBag generate() {
        return this.generate(new DropMetadataImpl(null, null));
    }

    public LootBag generate(DropMetadata meta) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Generating LootBag", new Object[0]);
        LootBag drops = new LootBag(meta);
        if (this.conditions.size() > 0) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateDropper(meta)) continue;
                return drops;
            }
        }
        if (this.conditionsTrigger.size() > 0) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateDropCause(meta)) continue;
                return drops;
            }
        }
        int amountModifiers = 0;
        double bonusLevelMod = this.bonusLevelItems.get();
        double bonusLuckMod = this.bonusLuckItems.get();
        if (bonusLevelMod != 0.0) {
            amountModifiers += meta.getDropper().isPresent() ? (int)(meta.getDropper().get().getLevel() * bonusLevelMod) : 0;
        }
        if (bonusLuckMod != 0.0) {
            double causeLuck = meta.getCause().isPresent() ? (double)((int)((double)meta.getCause().get().getLuck() * bonusLuckMod)) : 0.0;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "BonusLuckMod: {0} - Killer Luck: {1}", bonusLuckMod, causeLuck);
            amountModifiers = (int)((double)amountModifiers + causeLuck);
        }
        if (this.minItems > 0 && this.maxItems > 0) {
            int diff = this.maxItems - this.minItems;
            int amount = diff > 0 ? Numbers.randomInt(diff) + this.minItems + amountModifiers : this.maxItems + amountModifiers;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Rand {1} to {2}): {0}", amount, this.minItems, this.maxItems);
            Collection<Drop> d = this.drops.get(amount);
            for (Drop drop : d) {
                if (this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        } else if (this.minItems > 0) {
            int diff = this.drops.size() - this.minItems;
            int amount = diff > 0 ? Numbers.randomInt(diff) + this.minItems + amountModifiers : this.minItems + amountModifiers;
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Min {1}): {0}", amount, this.minItems);
            for (Drop drop : this.drops.get(amount)) {
                if (this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        } else if (this.maxItems > 0) {
            int items = 0 - amountModifiers;
            for (Drop drop : this.drops.getView()) {
                if (drop.rollChance()) {
                    ++items;
                    if (!this.handleDrop(meta, drops, drop)) {
                        return drops;
                    }
                }
                if (items < this.maxItems) continue;
                break;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Amount (Max {1}): {0}", items, this.maxItems);
        } else {
            for (Drop drop : this.drops.getView()) {
                if (!drop.rollChance() || this.handleDrop(meta, drops, drop)) continue;
                return drops;
            }
        }
        return drops;
    }

    private boolean handleDrop(DropMetadata meta, LootBag drops, Drop drop) {
        drop.rollAmount(meta);
        if (drop instanceof IMultiDrop) {
            IMultiDrop multiDrop = (IMultiDrop)((Object)drop);
            if (meta.tick() > 100) {
                return false;
            }
            int i = 0;
            while ((double)i < drop.getAmount()) {
                drops.add(meta, multiDrop.get(meta));
                ++i;
            }
        } else if (drop instanceof ICommandDrop) {
            drops.add(meta, drop);
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Handling Item {0} amount {1}", drop.getLine(), drop.getAmount());
            drops.add(meta, drop);
        }
        return true;
    }

    public boolean usesWeights() {
        if (this.minItems > 0 && this.maxItems > 0) {
            return true;
        }
        return this.minItems > 0;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public DropExecutor getManager() {
        return this.manager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public WeightedCollection<Drop> getDrops() {
        return this.drops;
    }
}

