/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;

public class DropMetadataImpl
implements DropMetadata,
Cloneable,
PlaceholderMeta {
    private final Optional<SkillCaster> dropper;
    private final Optional<AbstractEntity> cause;
    private final Optional<PlaceholderMeta> extraPlaceholderMeta;
    private Map<String, Object> metadata;
    private Optional<ItemStack> item;
    private float amount = 0.0f;
    private double level = 1.0;
    private int generations = 0;

    public DropMetadataImpl(SkillCaster dropper, AbstractEntity killer) {
        this.dropper = Optional.ofNullable(dropper);
        this.cause = Optional.ofNullable(killer);
        this.extraPlaceholderMeta = Optional.empty();
    }

    public DropMetadataImpl(SkillCaster dropper, AbstractEntity killer, double level) {
        this.dropper = Optional.ofNullable(dropper);
        this.cause = Optional.ofNullable(killer);
        this.level = level;
        this.extraPlaceholderMeta = Optional.empty();
    }

    public DropMetadataImpl(SkillCaster dropper, AbstractEntity killer, PlaceholderMeta extraMeta, Integer level) {
        this.dropper = Optional.ofNullable(dropper);
        this.cause = Optional.ofNullable(killer);
        this.extraPlaceholderMeta = Optional.of(extraMeta);
        if (level != null) {
            this.level = level.intValue();
        }
    }

    @Override
    public int tick() {
        return this.generations++;
    }

    @Override
    public SkillCaster getCaster() {
        return this.dropper.orElse(null);
    }

    @Override
    public AbstractEntity getTrigger() {
        return this.cause.orElse(null);
    }

    @Override
    public PlaceholderMeta getExtraPlaceholderMeta() {
        return this.extraPlaceholderMeta.orElse(null);
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = Optional.ofNullable(item);
    }

    @Override
    public DropMetadataImpl setMetadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = Maps.newHashMap();
        }
        this.metadata.put(key, value);
        return this;
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        if (this.metadata != null && this.metadata.containsKey(key)) {
            return Optional.of(this.metadata.get(key));
        }
        if (this.extraPlaceholderMeta.isPresent()) {
            return this.extraPlaceholderMeta.get().getMetadata(key);
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> getMetadata(Class<T> clazz, String key) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(key, "key");
        Object value = this.metadata.getOrDefault(key, null);
        if (value == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(value)) {
            return Optional.empty();
        }
        return Optional.of(clazz.cast(value));
    }

    @Override
    public Optional<Object> removeMetadata(String key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(this.metadata.remove(key));
    }

    @Override
    public <T> Optional<T> removeMetadata(Class<T> clazz, String key) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(key, "key");
        Object value = this.metadata.remove(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!clazz.isInstance(value)) {
            return Optional.empty();
        }
        return Optional.of(clazz.cast(value));
    }

    @Override
    public void clearMetadata() {
        this.metadata.clear();
    }

    @Override
    public DropMetadata clone() {
        try {
            return (DropMetadata)super.clone();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DropMetadataImpl deeperClone() {
        DropMetadataImpl clone = (DropMetadataImpl)this.clone();
        if (this.metadata != null) {
            clone.setMetadata(Maps.newHashMap(this.metadata));
        }
        return clone;
    }

    @Override
    public Optional<SkillCaster> getDropper() {
        return this.dropper;
    }

    @Override
    public Optional<AbstractEntity> getCause() {
        return this.cause;
    }

    @Override
    public Optional<ItemStack> getItem() {
        return this.item;
    }

    @Override
    public float getAmount() {
        return this.amount;
    }

    @Override
    public double getLevel() {
        return this.level;
    }

    @Override
    public int getGenerations() {
        return this.generations;
    }

    @Override
    public void setAmount(float amount) {
        this.amount = amount;
    }

    @Override
    public void setLevel(double level) {
        this.level = level;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropMetadataImpl)) {
            return false;
        }
        DropMetadataImpl other = (DropMetadataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getLevel(), other.getLevel()) != 0) {
            return false;
        }
        if (this.getGenerations() != other.getGenerations()) {
            return false;
        }
        Optional<SkillCaster> this$dropper = this.getDropper();
        Optional<SkillCaster> other$dropper = other.getDropper();
        if (this$dropper == null ? other$dropper != null : !((Object)this$dropper).equals(other$dropper)) {
            return false;
        }
        Optional<AbstractEntity> this$cause = this.getCause();
        Optional<AbstractEntity> other$cause = other.getCause();
        if (this$cause == null ? other$cause != null : !((Object)this$cause).equals(other$cause)) {
            return false;
        }
        PlaceholderMeta this$extraPlaceholderMeta = this.getExtraPlaceholderMeta();
        PlaceholderMeta other$extraPlaceholderMeta = other.getExtraPlaceholderMeta();
        if (this$extraPlaceholderMeta == null ? other$extraPlaceholderMeta != null : !this$extraPlaceholderMeta.equals(other$extraPlaceholderMeta)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Optional<ItemStack> this$item = this.getItem();
        Optional<ItemStack> other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropMetadataImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAmount());
        long $level = Double.doubleToLongBits(this.getLevel());
        result = result * 59 + (int)($level >>> 32 ^ $level);
        result = result * 59 + this.getGenerations();
        Optional<SkillCaster> $dropper = this.getDropper();
        result = result * 59 + ($dropper == null ? 43 : ((Object)$dropper).hashCode());
        Optional<AbstractEntity> $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : ((Object)$cause).hashCode());
        PlaceholderMeta $extraPlaceholderMeta = this.getExtraPlaceholderMeta();
        result = result * 59 + ($extraPlaceholderMeta == null ? 43 : $extraPlaceholderMeta.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Optional<ItemStack> $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "DropMetadataImpl(dropper=" + String.valueOf(this.getDropper()) + ", cause=" + String.valueOf(this.getCause()) + ", extraPlaceholderMeta=" + String.valueOf(this.getExtraPlaceholderMeta()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", item=" + String.valueOf(this.getItem()) + ", amount=" + this.getAmount() + ", level=" + this.getLevel() + ", generations=" + this.getGenerations() + ")";
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }
}

