/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.utils.collections.AWeightedItem;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomDouble;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticDouble;
import io.lumine.mythic.core.utils.MathParser;

public abstract class Drop
extends AWeightedItem
implements Cloneable,
IDrop {
    private final String line;
    private final MythicLineConfig config;
    protected String dropVar = null;
    protected EquipSlot equipSlot = null;
    private PlaceholderDouble dropAmount = null;
    private double amount = 1.0;

    public Drop(String line, MythicLineConfig config) {
        this.line = line;
        this.config = config;
        try {
            String token;
            String[] split = line.split(" ");
            int index = 1;
            if (split[0].contains(":")) {
                String[] bit = split[0].split(":", 2);
                this.dropVar = bit[1];
                if (EquipSlot.isEquipSlot(this.dropVar)) {
                    this.equipSlot = EquipSlot.of(this.dropVar.toUpperCase());
                }
            }
            if (split.length > index && EquipSlot.isEquipSlot(split[index])) {
                this.equipSlot = EquipSlot.of(split[index].toUpperCase());
                ++index;
            }
            if (split.length > index) {
                token = split[index];
                if (io.lumine.mythic.bukkit.utils.numbers.RandomDouble.matches(token) || token.startsWith("'")) {
                    this.dropAmount = PlaceholderDouble.of(token);
                    ++index;
                } else {
                    this.dropVar = token;
                    ++index;
                }
            }
            if (this.dropAmount == null && split.length > index && (io.lumine.mythic.bukkit.utils.numbers.RandomDouble.matches(token = split[index]) || token.startsWith("'"))) {
                this.dropAmount = PlaceholderDouble.of(token);
                ++index;
            }
            if (split.length > index) {
                this.weight = MathParser.evalChance(split[index]);
            }
        }
        catch (Exception ex) {
            MythicLogger.errorDropConfig(this, config, "Invalid Syntax");
            MythicLogger.handleMinorError(ex);
        }
        if (this.dropAmount == null) {
            this.dropAmount = PlaceholderDouble.of("1");
        }
    }

    public Drop(String line, MythicLineConfig config, double amount) {
        this(line, config);
        this.dropAmount = new StaticDouble(amount);
    }

    public Drop(String line, MythicLineConfig config, io.lumine.mythic.bukkit.utils.numbers.RandomDouble amount) {
        this(line, config);
        this.dropAmount = new RandomDouble(amount);
    }

    public boolean rollChance() {
        return this.weight == 1.0 || !(Numbers.randomDouble() > this.weight);
    }

    public void rollAmount(DropMetadata data) {
        this.amount = this.dropAmount.get(data);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().equals(this.getClass());
    }

    public Drop addAmount(Drop other) {
        this.amount += other.getAmount();
        return this.clone();
    }

    public Drop clone() {
        try {
            return (Drop)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLine() {
        return this.line;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public String getDropVar() {
        return this.dropVar;
    }

    public EquipSlot getEquipSlot() {
        return this.equipSlot;
    }

    public PlaceholderDouble getDropAmount() {
        return this.dropAmount;
    }

    public void setDropAmount(PlaceholderDouble dropAmount) {
        this.dropAmount = dropAmount;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
}

