/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.time;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class DurationParser {
    private static final Map<ChronoUnit, String> UNITS_PATTERNS = ImmutableMap.builder().put((Object)ChronoUnit.YEARS, (Object)"y(?:ear)?s?").put((Object)ChronoUnit.MONTHS, (Object)"mo(?:nth)?s?").put((Object)ChronoUnit.WEEKS, (Object)"w(?:eek)?s?").put((Object)ChronoUnit.DAYS, (Object)"d(?:ay)?s?").put((Object)ChronoUnit.HOURS, (Object)"h(?:our|r)?s?").put((Object)ChronoUnit.MINUTES, (Object)"m(?:inute|in)?s?").put((Object)ChronoUnit.SECONDS, (Object)"(?:s(?:econd|ec)?s?)?").build();
    private static final ChronoUnit[] UNITS = UNITS_PATTERNS.keySet().toArray(new ChronoUnit[0]);
    private static final String PATTERN_STRING = UNITS_PATTERNS.values().stream().map(pattern -> "(?:(\\d+)\\s*" + pattern + "[,\\s]*)?").collect(Collectors.joining());
    private static final Pattern PATTERN = Pattern.compile(PATTERN_STRING, 2);

    private DurationParser() {
    }

    public static Duration parse(String input) throws IllegalArgumentException {
        Matcher matcher = PATTERN.matcher(input);
        while (matcher.find()) {
            if (matcher.group() == null || matcher.group().isEmpty()) continue;
            Duration duration = Duration.ZERO;
            for (int i = 0; i < UNITS.length; ++i) {
                int n;
                ChronoUnit unit = UNITS[i];
                int g2 = i + 1;
                if (matcher.group(g2) == null || matcher.group(g2).isEmpty() || (n = Integer.parseInt(matcher.group(g2))) <= 0) continue;
                duration = duration.plus(unit.getDuration().multipliedBy(n));
            }
            return duration;
        }
        throw new IllegalArgumentException("unable to parse duration: " + input);
    }

    @Nonnull
    public static Optional<Duration> parseSafely(String input) {
        try {
            return Optional.of(DurationParser.parse(input));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }
}

