/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.storage.players;

import com.google.common.collect.Maps;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.storage.StorageModule;
import io.lumine.mythic.bukkit.utils.storage.events.LumineProfileLoadEvent;
import io.lumine.mythic.bukkit.utils.storage.players.MultiProfile;
import io.lumine.mythic.bukkit.utils.storage.players.PlayerStorageAdapter;
import io.lumine.mythic.bukkit.utils.storage.players.Profile;
import io.lumine.mythic.bukkit.utils.storage.players.ProfileRepository;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public abstract class PlayerRepository<T extends LuminePlugin, P extends Profile>
extends StorageModule<T>
implements ProfileRepository<P> {
    private final Map<UUID, P> profilesById = Maps.newConcurrentMap();
    private final Map<String, P> profilesByName = Maps.newConcurrentMap();
    private final Class<P> clazz;
    private PlayerStorageAdapter<P> adapter;
    protected boolean autoLoadProfiles = true;

    public PlayerRepository(T plugin, Class<P> clazz, PlayerStorageAdapter<P> adapter, boolean autoLoadProfiles) {
        super(plugin);
        this.clazz = clazz;
        this.autoLoadProfiles = autoLoadProfiles;
        this.initialize(adapter);
    }

    public PlayerRepository(T plugin, Class<P> clazz, PlayerStorageAdapter<P> adapter) {
        super(plugin);
        this.clazz = clazz;
        this.initialize(adapter);
    }

    public PlayerRepository(T plugin, Class<P> clazz) {
        super(plugin);
        this.clazz = clazz;
    }

    public void initialize(PlayerStorageAdapter<P> adapter) {
        this.adapter = adapter;
        this.load(this.plugin);
    }

    @Override
    public void load(T plugin) {
        if (this.autoLoadProfiles) {
            Events.subscribe(PlayerJoinEvent.class).handler(event -> this.loadProfile(event.getPlayer())).bindWith(this);
        }
        Events.subscribe(PlayerQuitEvent.class, EventPriority.MONITOR).handler(event -> {
            UUID uuid = event.getPlayer().getUniqueId();
            Profile profile = (Profile)this.profilesById.remove(uuid);
            this.profilesByName.remove(event.getPlayer().getName());
            if (profile != null) {
                this.unloadProfile(profile, event.getPlayer());
                this.adapter.save(uuid, profile);
            }
        }).bindWith(this);
    }

    @Override
    public void unload() {
        for (Map.Entry<UUID, P> entry : this.profilesById.entrySet()) {
            UUID uuid = entry.getKey();
            Profile profile = (Profile)entry.getValue();
            this.adapter.saveSync(uuid, profile);
        }
    }

    @Override
    public void saveAll() {
        for (Map.Entry<UUID, P> entry : this.profilesById.entrySet()) {
            UUID uuid = entry.getKey();
            Profile profile = (Profile)entry.getValue();
            this.adapter.save(uuid, profile);
        }
    }

    public void loadProfile(Player player) {
        this.loadProfile(player, 0);
    }

    public void loadProfile(Player player, int subProfile) {
        this.adapter.load(player.getUniqueId(), subProfile).thenAcceptSync(maybeProfile -> {
            Profile profile;
            if (!maybeProfile.isPresent()) {
                profile = this.createProfile(player.getUniqueId(), player.getName(), subProfile);
                this.adapter.save(profile.getUniqueId(), profile);
            } else {
                profile = (Profile)maybeProfile.get();
            }
            this.profilesById.put(player.getUniqueId(), profile);
            this.profilesByName.put(player.getName(), profile);
            this.initProfile(profile, player);
            Events.call(new LumineProfileLoadEvent<Profile>(player, profile));
        });
    }

    public abstract P createProfile(UUID var1, String var2, int var3);

    public abstract void initProfile(P var1, Player var2);

    public abstract void unloadProfile(P var1, Player var2);

    @Override
    public P getProfile(Player player) {
        return (P)((Profile)this.profilesById.getOrDefault(player.getUniqueId(), null));
    }

    @Override
    public Optional<P> getProfile(UUID uniqueId) {
        return Optional.ofNullable(this.profilesById.getOrDefault(uniqueId, null));
    }

    @Override
    public Optional<P> getProfile(String name) {
        return Optional.ofNullable(this.profilesByName.getOrDefault(name, null));
    }

    @Override
    public Collection<P> getKnownProfiles() {
        return this.profilesById.values();
    }

    public Promise<Optional<P>> awaitProfile(Player player) {
        Promise promise = Promise.empty();
        UUID uuid = player.getUniqueId();
        if (this.profilesById.containsKey(uuid)) {
            promise.supply(Optional.of((Profile)this.profilesById.get(uuid)));
        } else {
            Events.subscribe(LumineProfileLoadEvent.class, EventPriority.MONITOR).expireAfter(1L).expireAfter(5L, TimeUnit.SECONDS).filter(event -> event.getPlayer().getUniqueId().equals(player.getUniqueId())).filter(event -> this.clazz.isInstance(event.getProfile())).biHandler((handler, event) -> {
                promise.supply(Optional.of(event.getProfile()));
                handler.terminate();
            });
            if (this.profilesById.containsKey(uuid)) {
                promise.supply(Optional.of((Profile)this.profilesById.get(uuid)));
            }
        }
        return promise;
    }

    @Override
    public Promise<Optional<P>> lookupProfile(UUID uniqueId, int subProfile) {
        return this.adapter.load(uniqueId, subProfile);
    }

    @Override
    public Promise<Optional<P>> lookupProfile(String name, int subProfile) {
        return this.adapter.loadByName(name, subProfile);
    }

    @Override
    public Collection<P> getAvailableProfiles(UUID uniqueId) {
        if (!this.clazz.isAssignableFrom(MultiProfile.class)) {
            throw new IllegalStateException("PlayerRepository must implement MultiProfile to look up profiles");
        }
        return this.adapter.getAvailableProfiles(uniqueId);
    }

    @Override
    public Collection<P> getAvailableProfiles(String name) {
        if (!this.clazz.isAssignableFrom(MultiProfile.class)) {
            throw new IllegalStateException("PlayerRepository must implement MultiProfile to look up profiles");
        }
        return this.adapter.getAvailableProfiles(name);
    }

    public PlayerStorageAdapter<P> getAdapter() {
        return this.adapter;
    }
}

