/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.DyeColor;

public class Chroma
implements GsonSerializable {
    private static final double MAX_EUCLIDEAN_DISTANCE = Math.sqrt(195075.0);
    private final int rgb;
    private final int rgba;

    public static Chroma deserialize(String element) {
        Preconditions.checkNotNull((Object)element);
        int r = Integer.parseInt(element);
        return Chroma.of(r);
    }

    public static Chroma of(int rgba) {
        return new Chroma(rgba);
    }

    public static Chroma of(int r, int g2, int b) {
        return new Chroma(r, g2, b, 255);
    }

    public static Chroma of(int r, int g2, int b, int a) {
        return new Chroma(r, g2, b, a);
    }

    public static Chroma of(float r, float g2, float b) {
        return new Chroma((int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f), 65025);
    }

    public static Chroma of(float r, float g2, float b, float a) {
        return new Chroma((int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static Chroma of(DyeColor dyeColor) {
        return Chroma.of(dyeColor.getColor());
    }

    public static Chroma of(org.bukkit.Color bukkitColor) {
        int red = bukkitColor.asRGB() >> 16 & 0xFF;
        int green = bukkitColor.asRGB() >> 8 & 0xFF;
        int blue = bukkitColor.asRGB() & 0xFF;
        return Chroma.of(red, green, blue);
    }

    public static Chroma of(String input) {
        int a;
        int b;
        int g2;
        int r;
        if (input.startsWith("#")) {
            if (input.length() == 9) {
                long val = Long.parseLong(input.substring(1), 16);
                r = (int)(val >> 24) & 0xFF;
                g2 = (int)(val >> 16) & 0xFF;
                b = (int)(val >> 8) & 0xFF;
                a = (int)val & 0xFF;
            } else {
                Color color = Color.decode(input);
                r = color.getRed();
                g2 = color.getGreen();
                b = color.getBlue();
                a = 255;
            }
        } else if (input.contains(",")) {
            float alpha;
            String[] rgb = input.split(",");
            r = Integer.parseInt(rgb[0]);
            g2 = Integer.parseInt(rgb[1]);
            b = Integer.parseInt(rgb[2]);
            a = rgb.length > 3 ? ((alpha = Float.parseFloat(rgb[3].trim())) > 0.0f && alpha < 1.0f ? (int)(alpha * 255.0f) : (int)alpha) : 255;
        } else {
            Optional<Integer> maybeInt = Numbers.parseIntegerOpt(input);
            if (maybeInt.isPresent()) {
                return Chroma.of(maybeInt.get());
            }
            DyeColor dColor = DyeColor.valueOf((String)input.toUpperCase());
            org.bukkit.Color color = dColor.getFireworkColor();
            r = color.getRed();
            g2 = color.getGreen();
            b = color.getBlue();
            a = ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4) ? color.getAlpha() : 255;
        }
        return Chroma.of(r, g2, b, a);
    }

    private Chroma(int minecraftRGB) {
        int r = minecraftRGB >> 16 & 0xFF;
        int g2 = minecraftRGB >> 8 & 0xFF;
        int b = minecraftRGB & 0xFF;
        int a = 255;
        this.rgba = r << 24 | g2 << 16 | b << 8 | a;
        this.rgb = r << 16 | g2 << 8 | b;
    }

    private Chroma(int r, int g2, int b, int a) {
        this.rgba = (r & 0xFF) << 24 | (g2 & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
        this.rgb = (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF;
    }

    public Chroma(int r, int g2, int b, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int a = (int)(alpha * 255.0f) & 0xFF;
        this.rgba = (r & 0xFF) << 24 | (g2 & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
        this.rgb = (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF;
    }

    public int value() {
        return this.rgba;
    }

    public int red() {
        return this.value() >> 24 & 0xFF;
    }

    public int green() {
        return this.value() >> 16 & 0xFF;
    }

    public int blue() {
        return this.value() >> 8 & 0xFF;
    }

    public int alpha() {
        return this.value() & 0xFF;
    }

    public org.bukkit.Color toBukkitColor() {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            int argb = (this.alpha() & 0xFF) << 24 | (this.red() & 0xFF) << 16 | (this.green() & 0xFF) << 8 | this.blue() & 0xFF;
            return org.bukkit.Color.fromARGB((int)argb);
        }
        return org.bukkit.Color.fromRGB((int)this.rgb);
    }

    public org.bukkit.Color toSolidBukkitColor() {
        return org.bukkit.Color.fromRGB((int)this.rgb);
    }

    public DyeColor toBukkitDyeColor() {
        return DyeColor.getByColor((org.bukkit.Color)this.toSolidBukkitColor());
    }

    public TextColor toComponentColor() {
        return TextColor.color((int)this.rgb);
    }

    public String toHexString() {
        return String.format("#%06x", this.rgb);
    }

    public String toAlphaHexString() {
        return String.format("#%08x", this.value());
    }

    public Chroma blend(Chroma with, float i) {
        float clampedT = Math.min(1.0f, Math.max(0.0f, i));
        int ar = this.red();
        int ag = this.green();
        int ab = this.blue();
        int aa = this.alpha();
        int br = with.red();
        int bg = with.green();
        int bb = with.blue();
        int ba = with.alpha();
        return Chroma.of(Math.round((float)ar + clampedT * (float)(br - ar)), Math.round((float)ag + clampedT * (float)(bg - ag)), Math.round((float)ab + clampedT * (float)(bb - ab)), Math.round((float)aa + clampedT * (float)(ba - aa)));
    }

    public double getDistance(Chroma other) {
        int rDiff = this.red() - other.red();
        int gDiff = this.green() - other.green();
        int bDiff = this.blue() - other.blue();
        return Math.sqrt(rDiff * rDiff + gDiff * gDiff + bDiff * bDiff);
    }

    public int getDifference(Chroma other) {
        int rDiff = Math.abs(this.red() - other.red());
        int gDiff = Math.abs(this.green() - other.green());
        int bDiff = Math.abs(this.blue() - other.blue());
        return rDiff + gDiff + bDiff;
    }

    public Chroma constrainedBlend(Chroma with, int maxDifference) {
        int totalDifference = this.getDifference(with);
        float i = 1.0f;
        if (totalDifference > maxDifference) {
            i = (float)maxDifference / (float)totalDifference;
        }
        float clampedT = Math.min(1.0f, Math.max(0.0f, i));
        int ar = this.red();
        int ag = this.green();
        int ab = this.blue();
        int aa = this.alpha();
        int br = with.red();
        int bg = with.green();
        int bb = with.blue();
        int ba = with.alpha();
        return Chroma.of(Math.round((float)ar + clampedT * (float)(br - ar)), Math.round((float)ag + clampedT * (float)(bg - ag)), Math.round((float)ab + clampedT * (float)(bb - ab)), Math.round((float)aa + clampedT * (float)(ba - aa)));
    }

    public Chroma nearest(Collection<Chroma> chromas) {
        double minDifference = Double.MAX_VALUE;
        Chroma nearestChroma = null;
        for (Chroma otherChroma : chromas) {
            double diff = this.getDistance(otherChroma);
            if (!(diff < minDifference)) continue;
            minDifference = diff;
            nearestChroma = otherChroma;
        }
        return nearestChroma;
    }

    public DyeColor bestDyeTowards(Chroma target) {
        Dyes bestDye = null;
        Chroma bestBlend = null;
        double smallestDifference = Double.MAX_VALUE;
        for (Dyes dye : Dyes.collection()) {
            Chroma blendedColor = this.blend(dye.getBlendingColor(), 1.0f);
            double newDifference = blendedColor.getDistance(target);
            if (!(newDifference < smallestDifference)) continue;
            smallestDifference = newDifference;
            bestDye = dye;
            bestBlend = blendedColor;
        }
        return bestDye.getDyeColor();
    }

    public Map<DyeColor, Integer> getDyesTowards(Chroma targetColor, double threshold, int maxIterations) {
        HashMap<DyeColor, Integer> result = new HashMap<DyeColor, Integer>();
        double currentDifference = this.getDistance(targetColor);
        if (currentDifference <= 0.0) {
            return result;
        }
        Chroma currentColor = this;
        for (int i = 0; i < maxIterations; ++i) {
            Dyes bestDye = null;
            Chroma bestBlend = null;
            double smallestDifference = Double.MAX_VALUE;
            for (Dyes dye : Dyes.collection()) {
                Chroma blendedColor = currentColor.blend(dye.getBlendingColor(), 0.5f);
                double newDifference = blendedColor.getDistance(targetColor);
                if (!(newDifference < smallestDifference)) continue;
                smallestDifference = newDifference;
                bestDye = dye;
                bestBlend = blendedColor;
            }
            if (bestDye == null) break;
            currentColor = bestBlend;
            result.put(bestDye.getDyeColor(), result.getOrDefault(bestDye.getDyeColor(), 0) + 1);
            double similarity = 1.0 - smallestDifference / MAX_EUCLIDEAN_DISTANCE;
            if (similarity >= threshold) break;
        }
        return result;
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("color", this.rgba).build();
    }

    public String serializeShortForm() {
        return String.format("#%08x", this.value());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chroma)) {
            return false;
        }
        Chroma other = (Chroma)o;
        return Double.compare(this.red(), other.red()) == 0 && Double.compare(this.green(), other.green()) == 0 && Double.compare(this.blue(), other.blue()) == 0 && Double.compare(this.alpha(), other.alpha()) == 0;
    }

    public int hashCode() {
        return this.value();
    }

    public String toString() {
        return "Chroma(r=" + this.red() + ", g=" + this.green() + ", b=" + this.blue() + ", a=" + this.alpha() + ")";
    }

    public static enum Dyes {
        WHITE(Chroma.of("#F9FFFE"), Chroma.of("#FFFFFE"), DyeColor.WHITE),
        LIGHT_GRAY(Chroma.of("#9D9D97"), Chroma.of("#AAAAAA"), DyeColor.LIGHT_GRAY),
        GRAY(Chroma.of("#474F52"), Chroma.of("#666666"), DyeColor.GRAY),
        BLACK(Chroma.of("#1D1D21"), Chroma.of("#000000"), DyeColor.BLACK),
        BROWN(Chroma.of("#835432"), Chroma.of("#8B4513"), DyeColor.BROWN),
        RED(Chroma.of("#B02E26"), Chroma.of("#FF0000"), DyeColor.RED),
        ORANGE(Chroma.of("#F9801D"), Chroma.of("#FFA500"), DyeColor.ORANGE),
        YELLOW(Chroma.of("#FED83D"), Chroma.of("#FFFF00"), DyeColor.YELLOW),
        LIME(Chroma.of("#80C71F"), Chroma.of("#00FF00"), DyeColor.LIME),
        GREEN(Chroma.of("#5E7C16"), Chroma.of("#008000"), DyeColor.GREEN),
        CYAN(Chroma.of("#169C9C"), Chroma.of("#00FFFF"), DyeColor.CYAN),
        LIGHT_BLUE(Chroma.of("#3AB3DA"), Chroma.of("#ADD8E6"), DyeColor.LIGHT_BLUE),
        BLUE(Chroma.of("#3C44AA"), Chroma.of("#0000FF"), DyeColor.BLUE),
        PURPLE(Chroma.of("#8932B8"), Chroma.of("#800080"), DyeColor.PURPLE),
        MAGENTA(Chroma.of("#C74EBD"), Chroma.of("#FF00FF"), DyeColor.MAGENTA),
        PINK(Chroma.of("#F38BAA"), Chroma.of("#FFC0CB"), DyeColor.PINK);

        private final Chroma color;
        private final Chroma blendingColor;
        private final DyeColor dyeColor;

        private Dyes(Chroma color, Chroma blendingColor, DyeColor dyeColor) {
            this.color = color;
            this.blendingColor = blendingColor;
            this.dyeColor = dyeColor;
        }

        public static List<Dyes> collection() {
            return Collections.unmodifiableList(Arrays.asList(Dyes.values()));
        }

        public Chroma getColor() {
            return this.color;
        }

        public Chroma getBlendingColor() {
            return this.blendingColor;
        }

        public DyeColor getDyeColor() {
            return this.dyeColor;
        }
    }
}

