/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import io.lumine.mythic.bukkit.utils.serialize.BlockLocus;
import io.lumine.mythic.bukkit.utils.serialize.Direction;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;

public final class BlockOrient
implements GsonSerializable {
    private final BlockLocus locus;
    private final Direction direction;

    public static BlockOrient deserialize(String element) {
        return BlockOrient.deserialize(element, BlockOrient.of(0, 0, 0, 0.0f, 0.0f));
    }

    public static BlockOrient deserialize(String element, BlockOrient def) {
        Preconditions.checkNotNull((Object)element);
        String[] values = element.split(",");
        int x = Integer.parseInt(values[0]);
        int y = Integer.parseInt(values[1]);
        int z = Integer.parseInt(values[2]);
        float yaw = values.length > 3 ? Float.parseFloat(values[3]) : def.getDirection().getYaw();
        float pitch = values.length > 4 ? Float.parseFloat(values[4]) : def.getDirection().getPitch();
        return BlockOrient.of(x, y, z, yaw, pitch);
    }

    public static BlockOrient deserialize(JsonElement element) {
        BlockLocus locus = BlockLocus.deserialize(element);
        Direction direction = Direction.deserialize(element);
        return BlockOrient.of(locus, direction);
    }

    public static BlockOrient of(BlockLocus locus, Direction direction) {
        Objects.requireNonNull(locus, "locus");
        Objects.requireNonNull(direction, "direction");
        return new BlockOrient(locus, direction);
    }

    public static BlockOrient of(Location location) {
        Objects.requireNonNull(location, "location");
        return BlockOrient.of(BlockLocus.of(location), Direction.from(location));
    }

    public static BlockOrient of(int x, int y, int z, float yaw, float pitch) {
        return BlockOrient.of(BlockLocus.of(x, y, z), Direction.of(yaw, pitch));
    }

    private BlockOrient(BlockLocus locus, Direction direction) {
        this.locus = locus;
        this.direction = direction;
    }

    public BlockLocus getLocus() {
        return this.locus;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Location toLocation(World world) {
        return new Location(world, (double)this.locus.getX(), (double)this.locus.getY(), (double)this.locus.getZ(), this.direction.getYaw(), this.direction.getPitch());
    }

    public synchronized Location toCenteredLocation(World world) {
        return new Location(world, (double)this.locus.getX() + 0.5, (double)this.locus.getY(), (double)this.locus.getZ() + 0.5, this.direction.getYaw(), this.direction.getPitch());
    }

    public BlockOrient add(int x, int y, int z) {
        return this.locus.add(x, y, z).withDirection(this.direction);
    }

    public BlockOrient subtract(int x, int y, int z) {
        return this.locus.subtract(x, y, z).withDirection(this.direction);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().addAll(this.locus.serialize()).addAll(this.direction.serialize()).build();
    }

    public String serializeShortForm() {
        return this.locus.serializeShortForm() + "," + this.direction.serializeShortForm();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockOrient)) {
            return false;
        }
        BlockOrient other = (BlockOrient)o;
        return this.getLocus().equals(other.getLocus()) && this.getDirection().equals(other.getDirection());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLocus().hashCode();
        result = result * 59 + this.getDirection().hashCode();
        return result;
    }

    public String toString() {
        return "BlockOrient(locus=" + String.valueOf(this.getLocus()) + ", direction=" + String.valueOf(this.getDirection()) + ")";
    }
}

