/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.redis.jedis.util;

import io.lumine.mythic.bukkit.utils.redis.jedis.util.Hashing;
import io.lumine.mythic.bukkit.utils.redis.jedis.util.SafeEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MurmurHash
implements Hashing {
    public static int hash(byte[] data, int seed) {
        return MurmurHash.hash(ByteBuffer.wrap(data), seed);
    }

    public static int hash(byte[] data, int offset, int length, int seed) {
        return MurmurHash.hash(ByteBuffer.wrap(data, offset, length), seed);
    }

    public static int hash(ByteBuffer buf, int seed) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int m4 = 1540483477;
        int r = 24;
        int h2 = seed ^ buf.remaining();
        while (buf.remaining() >= 4) {
            int k = buf.getInt();
            k *= m4;
            k ^= k >>> r;
            h2 *= m4;
            h2 ^= (k *= m4);
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h2 ^= finish.getInt();
            h2 *= m4;
        }
        h2 ^= h2 >>> 13;
        h2 *= m4;
        h2 ^= h2 >>> 15;
        buf.order(byteOrder);
        return h2;
    }

    public static long hash64A(byte[] data, int seed) {
        return MurmurHash.hash64A(ByteBuffer.wrap(data), seed);
    }

    public static long hash64A(byte[] data, int offset, int length, int seed) {
        return MurmurHash.hash64A(ByteBuffer.wrap(data, offset, length), seed);
    }

    public static long hash64A(ByteBuffer buf, int seed) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m4 = -4132994306676758123L;
        int r = 47;
        long h2 = (long)seed ^ (long)buf.remaining() * m4;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m4;
            k ^= k >>> r;
            h2 ^= (k *= m4);
            h2 *= m4;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h2 ^= finish.getLong();
            h2 *= m4;
        }
        h2 ^= h2 >>> r;
        h2 *= m4;
        h2 ^= h2 >>> r;
        buf.order(byteOrder);
        return h2;
    }

    @Override
    public long hash(byte[] key) {
        return MurmurHash.hash64A(key, 305441741);
    }

    @Override
    public long hash(String key) {
        return this.hash(SafeEncoder.encode(key));
    }
}

