/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.promise;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LoaderUtils;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.promise.ThreadContext;
import io.lumine.mythic.bukkit.utils.tasks.LumineExecutors;
import io.lumine.mythic.bukkit.utils.tasks.Ticks;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

final class LuminePromise<V>
implements Promise<V> {
    private static final Consumer<Throwable> EXCEPTION_CONSUMER = throwable -> {
        Log.severe("[SCHEDULER] Exception thrown whilst executing task");
        throwable.printStackTrace();
    };
    @Nullable
    private Entity boundEntity = null;
    @Nullable
    private Location boundLocation = null;
    private final AtomicBoolean supplied = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    @Nonnull
    private final CompletableFuture<V> fut;

    @Nonnull
    static <U> LuminePromise<U> empty() {
        return new LuminePromise();
    }

    @Nonnull
    static <U> LuminePromise<U> completed(@Nullable U value) {
        return new LuminePromise<U>(value);
    }

    @Nonnull
    static <U> LuminePromise<U> exceptionally(@Nonnull Throwable t2) {
        return new LuminePromise(t2);
    }

    @Nonnull
    static <U> Promise<U> wrapFuture(@Nonnull Future<U> future) {
        if (future instanceof CompletableFuture) {
            return new LuminePromise(((CompletableFuture)future).thenApply(Function.identity()));
        }
        if (future instanceof CompletionStage) {
            CompletionStage fut = (CompletionStage)((Object)future);
            return new LuminePromise(fut.toCompletableFuture().thenApply(Function.identity()));
        }
        if (future instanceof ListenableFuture) {
            ListenableFuture fut = (ListenableFuture)future;
            final LuminePromise<U> promise = LuminePromise.empty();
            promise.supplied.set(true);
            Futures.addCallback((ListenableFuture)fut, (FutureCallback)new FutureCallback<U>(){

                public void onSuccess(@Nullable U result) {
                    promise.complete(result);
                }

                public void onFailure(@Nonnull Throwable t2) {
                    promise.completeExceptionally(t2);
                }
            }, (Executor)LumineExecutors.asyncBukkit());
            return promise;
        }
        if (future.isDone()) {
            try {
                return LuminePromise.completed(future.get());
            }
            catch (ExecutionException e) {
                return LuminePromise.exceptionally(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return Promise.supplyingExceptionallyAsync(future::get);
    }

    @Nonnull
    static <U> LuminePromise<U> completedAt(@Nonnull Entity entity, @Nullable U value) {
        LuminePromise<U> p = value == null ? new LuminePromise<U>() : new LuminePromise<U>(value);
        p.boundEntity = Objects.requireNonNull(entity, "entity");
        p.supplied.set(true);
        if (value != null) {
            p.complete(value);
        } else {
            p.complete(null);
        }
        return p;
    }

    @Nonnull
    static <U> LuminePromise<U> completedAt(@Nonnull Location location, @Nullable U value) {
        LuminePromise<U> p = value == null ? new LuminePromise<U>() : new LuminePromise<U>(value);
        p.boundLocation = Objects.requireNonNull(location, "location");
        p.supplied.set(true);
        if (value != null) {
            p.complete(value);
        } else {
            p.complete(null);
        }
        return p;
    }

    private LuminePromise() {
        this.fut = new CompletableFuture();
    }

    private LuminePromise(@Nullable V v) {
        this.fut = CompletableFuture.completedFuture(v);
        this.supplied.set(true);
    }

    private LuminePromise(@Nonnull Throwable t2) {
        this.fut = new CompletableFuture();
        this.fut.completeExceptionally(t2);
        this.supplied.set(true);
    }

    private LuminePromise(@Nonnull CompletableFuture<V> fut) {
        this.fut = Objects.requireNonNull(fut, "future");
        this.supplied.set(true);
        this.cancelled.set(fut.isCancelled());
    }

    private void executeSync(@Nonnull Runnable runnable) {
        if (ServerVersion.isFolia()) {
            this.foliaExecute(runnable);
            return;
        }
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            LumineExecutors.wrapRunnable(runnable).run();
        } else {
            LumineExecutors.sync().execute(runnable);
        }
    }

    private void executeAsync(@Nonnull Runnable runnable) {
        LumineExecutors.asyncLumine().execute(runnable);
    }

    private void executeDelayedSync(@Nonnull Runnable runnable, long delayTicks) {
        if (ServerVersion.isFolia()) {
            this.foliaExecuteDelayed(runnable, delayTicks);
            return;
        }
        if (delayTicks <= 0L) {
            this.executeSync(runnable);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)LoaderUtils.getPlugin(), LumineExecutors.wrapRunnable(runnable), delayTicks);
        }
    }

    private void executeDelayedAsync(@Nonnull Runnable runnable, long delayTicks) {
        if (delayTicks <= 0L) {
            this.executeAsync(runnable);
        } else if (ServerVersion.isFolia()) {
            LumineExecutors.asyncLumine().schedule(LumineExecutors.wrapRunnable(runnable), delayTicks * 50L, TimeUnit.MILLISECONDS);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)LoaderUtils.getPlugin(), LumineExecutors.wrapRunnable(runnable), delayTicks);
        }
    }

    private void executeDelayedSync(@Nonnull Runnable runnable, long delay, TimeUnit unit) {
        if (ServerVersion.isFolia()) {
            this.foliaExecuteDelayed(runnable, Ticks.from(delay, unit));
            return;
        }
        if (delay <= 0L) {
            this.executeSync(runnable);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)LoaderUtils.getPlugin(), LumineExecutors.wrapRunnable(runnable), Ticks.from(delay, unit));
        }
    }

    private void executeDelayedAsync(@Nonnull Runnable runnable, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            this.executeAsync(runnable);
        } else {
            LumineExecutors.asyncLumine().schedule(LumineExecutors.wrapRunnable(runnable), delay, unit);
        }
    }

    private void foliaExecute(@Nonnull Runnable runnable) {
        if (this.boundEntity != null) {
            this.boundEntity.getScheduler().run((Plugin)LoaderUtils.getPlugin(), task -> runnable.run(), null);
            return;
        }
        if (this.boundLocation != null) {
            Bukkit.getServer().getRegionScheduler().execute((Plugin)LoaderUtils.getPlugin(), this.boundLocation, runnable);
            return;
        }
        Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)LoaderUtils.getPlugin(), runnable);
    }

    private void foliaExecuteDelayed(@Nonnull Runnable runnable, long delayTicks) {
        if (delayTicks <= 0L) {
            this.foliaExecute(runnable);
            return;
        }
        if (this.boundEntity != null) {
            this.boundEntity.getScheduler().runDelayed((Plugin)LoaderUtils.getPlugin(), task -> runnable.run(), null, delayTicks);
            return;
        }
        if (this.boundLocation != null) {
            Bukkit.getServer().getRegionScheduler().runDelayed((Plugin)LoaderUtils.getPlugin(), this.boundLocation, no -> runnable.run(), delayTicks);
            return;
        }
        Bukkit.getServer().getGlobalRegionScheduler().runDelayed((Plugin)LoaderUtils.getPlugin(), no -> runnable.run(), delayTicks);
    }

    private boolean complete(V value) {
        return !this.cancelled.get() && this.fut.complete(value);
    }

    private boolean completeExceptionally(@Nonnull Throwable t2) {
        return !this.cancelled.get() && this.fut.completeExceptionally(t2);
    }

    private void markAsSupplied() {
        if (!this.supplied.compareAndSet(false, true)) {
            throw new IllegalStateException("Promise is already being supplied.");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        return this.fut.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.fut.get();
    }

    @Override
    public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.fut.get(timeout, unit);
    }

    @Override
    public V join() {
        return this.fut.join();
    }

    @Override
    public V getNow(V valueIfAbsent) {
        return this.fut.getNow(valueIfAbsent);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this.fut.thenApply(Function.identity());
    }

    @Override
    public void close() {
        this.cancel();
    }

    @Override
    public boolean hasTerminated() {
        return this.isCancelled();
    }

    @Override
    @Nonnull
    public Promise<V> supply(@Nullable V value) {
        this.markAsSupplied();
        this.complete(value);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyException(@Nonnull Throwable exception) {
        this.markAsSupplied();
        this.completeExceptionally(exception);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplySync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeSync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyAsync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeAsync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> supplier, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedSync(new SupplyRunnable(supplier), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> supplier, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedSync(new SupplyRunnable(supplier), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> supplier, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedAsync(new SupplyRunnable(supplier), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> supplier, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedAsync(new SupplyRunnable(supplier), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallySync(@Nonnull Callable<V> callable) {
        this.markAsSupplied();
        this.executeSync(new ThrowingSupplyRunnable(callable));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyAsync(@Nonnull Callable<V> callable) {
        this.markAsSupplied();
        this.executeAsync(new ThrowingSupplyRunnable(callable));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedSync(@Nonnull Callable<V> callable, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedSync(new ThrowingSupplyRunnable(callable), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedSync(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedSync(new ThrowingSupplyRunnable(callable), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedAsync(@Nonnull Callable<V> callable, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedAsync(new ThrowingSupplyRunnable(callable), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedAsync(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedAsync(new ThrowingSupplyRunnable(callable), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplySync(@Nonnull Function<? super V, ? extends U> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeSync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeAsync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ApplyRunnable(promise, fn, value), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ApplyRunnable(promise, fn, value), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeDelayedAsync(new ApplyRunnable(promise, fn, value), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeDelayedAsync(new ApplyRunnable(promise, fn, value), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeSync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeSync(new ComposeRunnable(promise, fn, value, true));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeAsync(new ComposeRunnable(promise, fn, value, false));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallySync(@Nonnull Function<Throwable, ? extends V> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeSync(new ExceptionallyRunnable(promise, fn, (Throwable)t2));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyAsync(@Nonnull Function<Throwable, ? extends V> fn) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                this.executeAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t2));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ExceptionallyRunnable(promise, fn, (Throwable)t2), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ExceptionallyRunnable(promise, fn, (Throwable)t2), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                this.executeDelayedAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t2), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 == null) {
                promise.complete(value);
            } else {
                this.executeDelayedAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t2), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ComposeRunnable(promise, fn, value, true), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                promise.boundEntity = this.boundEntity;
                promise.boundLocation = this.boundLocation;
                this.executeDelayedSync(new ComposeRunnable(promise, fn, value, true), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delayTicks) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeDelayedAsync(new ComposeRunnable(promise, fn, value, false), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay, @Nonnull TimeUnit unit) {
        LuminePromise promise = LuminePromise.empty();
        this.fut.whenComplete((value, t2) -> {
            if (t2 != null) {
                promise.completeExceptionally((Throwable)t2);
            } else {
                this.executeDelayedAsync(new ComposeRunnable(promise, fn, value, false), delay, unit);
            }
        });
        return promise;
    }

    private final class SupplyRunnable
    implements Runnable {
        private final Supplier<V> supplier;

        private SupplyRunnable(Supplier<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void run() {
            if (LuminePromise.this.cancelled.get()) {
                return;
            }
            try {
                LuminePromise.this.fut.complete(this.supplier.get());
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                LuminePromise.this.fut.completeExceptionally(t2);
            }
        }
    }

    private final class ThrowingSupplyRunnable
    implements Runnable {
        private final Callable<V> supplier;

        private ThrowingSupplyRunnable(Callable<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void run() {
            if (LuminePromise.this.cancelled.get()) {
                return;
            }
            try {
                LuminePromise.this.fut.complete(this.supplier.call());
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                LuminePromise.this.fut.completeExceptionally(t2);
            }
        }
    }

    private final class ComposeRunnable<U>
    implements Runnable {
        private final LuminePromise<U> promise;
        private final Function<? super V, ? extends Promise<U>> function;
        private final V value;
        private final boolean sync;

        private ComposeRunnable(LuminePromise<U> promise, Function<? super V, ? extends Promise<U>> function, V value, boolean sync) {
            this.promise = promise;
            this.function = function;
            this.value = value;
            this.sync = sync;
        }

        @Override
        public void run() {
            if (LuminePromise.this.cancelled.get()) {
                return;
            }
            try {
                Promise<U> p = this.function.apply(this.value);
                if (p == null) {
                    this.promise.complete(null);
                } else if (this.sync) {
                    p.thenAcceptSync(this.promise::complete);
                } else {
                    p.thenAcceptAsync(this.promise::complete);
                }
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                this.promise.completeExceptionally(t2);
            }
        }
    }

    private final class ExceptionallyRunnable<U>
    implements Runnable {
        private final LuminePromise<U> promise;
        private final Function<Throwable, ? extends U> function;
        private final Throwable t;

        private ExceptionallyRunnable(LuminePromise<U> promise, Function<Throwable, ? extends U> function, Throwable t2) {
            this.promise = promise;
            this.function = function;
            this.t = t2;
        }

        @Override
        public void run() {
            if (LuminePromise.this.cancelled.get()) {
                return;
            }
            try {
                this.promise.complete(this.function.apply(this.t));
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                this.promise.completeExceptionally(t2);
            }
        }
    }

    private final class ApplyRunnable<U>
    implements Runnable {
        private final LuminePromise<U> promise;
        private final Function<? super V, ? extends U> function;
        private final V value;

        private ApplyRunnable(LuminePromise<U> promise, Function<? super V, ? extends U> function, V value) {
            this.promise = promise;
            this.function = function;
            this.value = value;
        }

        @Override
        public void run() {
            if (LuminePromise.this.cancelled.get()) {
                return;
            }
            try {
                this.promise.complete(this.function.apply(this.value));
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
                this.promise.completeExceptionally(t2);
            }
        }
    }
}

