/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files;

import io.lumine.mythic.bukkit.utils.particles.reflection.Version;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.Mappings;
import io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingType;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MappingFileReader {
    private static final Pattern VERSION_PATTERN = Pattern.compile("# reflection-remapper \\| (?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+)");
    @NotNull
    private final MappingType mappingType;
    @NotNull
    private final List<VersionPart> mappings;

    public MappingFileReader(@NotNull MappingType mappingType, @NotNull List<String> lines) throws IOException {
        this.mappingType = mappingType;
        this.mappings = MappingFileReader.readParts(lines);
    }

    public MappingFileReader(@NotNull MappingType mappingType, @NotNull List<String> lines, @NotNull Version version) throws IOException {
        this.mappingType = mappingType;
        this.mappings = List.of(new VersionPart(version, lines));
    }

    @NotNull
    public List<Version> getAvailableVersions() {
        return this.mappings.stream().map(x -> x.version).sorted().toList();
    }

    public boolean keepOnlyVersion(@NotNull Version version) {
        if (!this.mappings.stream().anyMatch(part -> part.version.equals(version))) {
            return false;
        }
        this.mappings.removeIf(part -> !part.version.equals(version));
        return true;
    }

    @NotNull
    public Optional<Version> keepBestMatchedVersion(@NotNull Version targetVersion) {
        Optional<Version> foundVersion = MappingFileReader.getBestMatchedVersion(targetVersion, this.getAvailableVersions());
        if (foundVersion.isPresent()) {
            this.keepOnlyVersion(foundVersion.get());
        }
        return foundVersion;
    }

    public void parseMappings() {
        for (VersionPart version : this.mappings) {
            version.mappings = this.mappingType.parse(version.lines);
        }
    }

    @NotNull
    public Mappings getParsedMappings(@NotNull Version version) {
        return this.mappings.stream().filter((Predicate<VersionPart>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getParsedMappings$3(io.lumine.mythic.bukkit.utils.particles.reflection.Version io.lumine.mythic.bukkit.utils.particles.reflection.mappings.files.MappingFileReader$VersionPart ), (Lio/lumine/mythic/bukkit/utils/particles/reflection/mappings/files/MappingFileReader$VersionPart;)Z)((Version)version)).findAny().orElseThrow().mappings;
    }

    @NotNull
    private static List<VersionPart> readParts(@NotNull List<String> lines) {
        ArrayList<VersionPart> parts = new ArrayList<VersionPart>();
        VersionPart currentPart = null;
        for (String line : lines) {
            Matcher versionMatcher = VERSION_PATTERN.matcher(line);
            if (versionMatcher.matches()) {
                if (currentPart != null) {
                    parts.add(currentPart);
                }
                currentPart = new VersionPart(new Version(Integer.parseInt(versionMatcher.group("major")), Integer.parseInt(versionMatcher.group("minor")), Integer.parseInt(versionMatcher.group("patch"))), new ArrayList<String>());
                continue;
            }
            if (line.startsWith("#") || line.isBlank()) continue;
            if (currentPart == null) {
                throw new IllegalArgumentException("File should start with a version information");
            }
            currentPart.lines.add(line);
        }
        if (currentPart != null) {
            parts.add(currentPart);
        }
        return parts;
    }

    @NotNull
    public static Optional<Version> getBestMatchedVersion(@NotNull Version targetVersion, @NotNull @NotNull List<@NotNull Version> availableVersions) {
        Version lastVersion = null;
        for (Version version : availableVersions) {
            if (version.is(targetVersion)) {
                return Optional.of(version);
            }
            if (version.isBefore(targetVersion)) {
                lastVersion = version;
            }
            if (!version.isAfter(targetVersion)) continue;
            break;
        }
        return Optional.ofNullable(lastVersion);
    }

    private static /* synthetic */ boolean lambda$getParsedMappings$3(Version version, VersionPart x) {
        return x.version.equals(version);
    }

    private static class VersionPart {
        private final Version version;
        private final List<String> lines;
        private Mappings mappings;

        private VersionPart(Version version, List<String> lines) {
            this.version = version;
            this.lines = lines;
        }
    }
}

