/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.Players;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.particles.Particle;
import java.awt.Color;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleBuilder {
    protected final Particle particle;
    protected Location location = null;
    protected Object particleData = null;
    protected int amount = 1;
    protected float speed = 0.0f;
    protected float offsetX = 0.0f;
    protected float offsetY = 0.0f;
    protected float offsetZ = 0.0f;
    protected boolean useExactOffsets;
    protected Vector towards = null;

    public static ParticleBuilder of(Particle particle) {
        return new ParticleBuilder(particle);
    }

    public ParticleBuilder(Particle particle2) {
        this.particle = particle2;
    }

    public ParticleBuilder withData(Object data) {
        if (data.getClass().isAssignableFrom(this.particle.toBukkitParticle().getDataType())) {
            this.particleData = data;
            return this;
        }
        if (data instanceof Material) {
            Material material = (Material)data;
            if (this.particle.toBukkitParticle().getDataType().equals(ItemStack.class)) {
                try {
                    this.particleData = new ItemStack(material);
                }
                catch (Exception ex) {
                    this.particleData = new ItemStack(Material.STONE);
                }
            } else if (this.particle.toBukkitParticle().getDataType().equals(BlockData.class)) {
                try {
                    this.particleData = Bukkit.getServer().createBlockData(material);
                }
                catch (Exception ex) {
                    this.particleData = Bukkit.getServer().createBlockData(Material.STONE);
                }
            } else if (this.particle.toBukkitParticle().getDataType().equals(MaterialData.class)) {
                try {
                    this.particleData = material.getData();
                }
                catch (Exception ex) {
                    this.particleData = Material.STONE.getData();
                }
            }
        }
        if (this.particle.toBukkitParticle().getDataType().equals(Particle.DustOptions.class)) {
            // empty if block
        }
        return this;
    }

    public ParticleBuilder at(Location location) {
        this.location = location;
        return this;
    }

    public ParticleBuilder amount(int i) {
        this.amount = i;
        return this;
    }

    public ParticleBuilder speed(float i) {
        this.speed = i;
        return this;
    }

    public ParticleBuilder offset(float i) {
        this.offsetX = i;
        this.offsetY = i;
        this.offsetZ = i;
        return this;
    }

    public ParticleBuilder offset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public ParticleBuilder offsetX(float i) {
        this.offsetX = i;
        return this;
    }

    public ParticleBuilder offsetY(float i) {
        this.offsetY = i;
        return this;
    }

    public ParticleBuilder offsetZ(float i) {
        this.offsetZ = i;
        return this;
    }

    public ParticleBuilder towards(Vector v) {
        this.towards = v;
        return this;
    }

    public ParticleBuilder useExactOffsets(boolean b) {
        this.useExactOffsets = b;
        return this;
    }

    public ParticleBuilder withColor(String strColor) {
        return this.withColorAndSize(strColor, 1.0f);
    }

    public ParticleBuilder withColorAndSize(String strColor, float size) {
        Color color = Color.decode(strColor);
        int r = color.getRed();
        int g2 = color.getGreen();
        int b = color.getBlue();
        org.bukkit.Color c = org.bukkit.Color.fromRGB((int)r, (int)g2, (int)b);
        this.particleData = new Particle.DustOptions(c, size);
        return this;
    }

    public void send() {
        this.send(this.location, Players.all());
    }

    public void send(Player to) {
        this.send(this.location, Lists.newArrayList((Object[])new Player[]{to}));
    }

    public void send(Player to, Location location) {
        this.send(location, Lists.newArrayList((Object[])new Player[]{to}));
    }

    public void send(Location location) {
        this.send(location, Players.all());
    }

    public void send(Collection<Player> to) {
        this.send(this.location, to);
    }

    public void send(Collection<Player> to, Location location) {
        this.send(location, to);
    }

    private void send(Location at, Collection<Player> to) {
        if (Bukkit.getServer().isPrimaryThread()) {
            Schedulers.async().run(() -> this.sendPackets(at, to));
        } else {
            this.sendPackets(at, to);
        }
    }

    private void sendPackets(Location loc, Collection<Player> to) {
        if (this.particleData != null && !this.particle.validateData(this.particleData)) {
            Log.error("Could not send particle: invalid particle data supplied.");
            return;
        }
        org.bukkit.Particle particle = this.particle.toBukkitParticle();
        if (this.towards != null) {
            for (int i = 0; i < this.amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - this.offsetX) + Numbers.randomDouble() * (double)this.offsetX * 2.0, (double)(this.offsetY - this.offsetY) + Numbers.randomDouble() * (double)this.offsetY * 2.0, (double)(0.0f - this.offsetZ) + Numbers.randomDouble() * (double)this.offsetZ * 2.0);
                for (Player player : to) {
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 0, (double)((float)this.towards.getX()), (double)((float)this.towards.getY()), (double)((float)this.towards.getZ()), (double)this.speed);
                }
            }
        } else if (this.useExactOffsets) {
            for (int i = 0; i < this.amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - this.offsetX) + Numbers.randomDouble() * (double)this.offsetX * 2.0, (double)(this.offsetY - this.offsetY) + Numbers.randomDouble() * (double)this.offsetY * 2.0, (double)(0.0f - this.offsetZ) + Numbers.randomDouble() * (double)this.offsetZ * 2.0);
                for (Player player : to) {
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 1, 0.0, 0.0, 0.0, (double)this.speed);
                }
            }
        } else if (this.particleData != null) {
            for (Player player : to) {
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, (double)this.speed, this.particleData);
            }
        } else {
            for (Player player : to) {
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, this.amount, (double)this.offsetX, (double)this.offsetY, (double)this.offsetZ, (double)this.speed);
            }
        }
    }
}

