/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedFloat {
    protected final Operation op;
    protected float min;
    protected float max;

    public RangedFloat(String value) {
        this(value, false);
    }

    public RangedFloat(String value, boolean squared) {
        if (value.startsWith(">=")) {
            float v;
            this.min = v = Float.parseFloat(value.substring(2));
            this.max = Float.MAX_VALUE;
            this.op = Operation.GREATER_THAN_OR_EQUAL;
        } else if (value.startsWith("<=")) {
            float v = Float.parseFloat(value.substring(2));
            this.min = -3.4028235E38f;
            this.max = v;
            this.op = Operation.LESS_THAN_OR_EQUAL;
        } else if (value.startsWith(">")) {
            float v;
            this.min = v = Float.parseFloat(value.substring(1));
            this.max = Float.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            float v = Float.parseFloat(value.substring(1));
            this.min = -3.4028235E38f;
            this.max = v;
            this.op = Operation.LESS_THAN;
        } else if (value.contains("to")) {
            String[] split = value.split("to");
            this.min = Float.parseFloat(split[0]);
            this.max = Float.parseFloat(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            String[] split = value.split("-");
            this.min = Float.parseFloat(split[0]);
            this.max = Float.parseFloat(split[1]);
            this.op = Operation.RANGE;
        } else {
            float v;
            this.min = v = Float.parseFloat(value);
            this.max = v;
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            float tmp = this.min;
            this.min = this.max;
            this.max = tmp;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        float d = ((Number)o).floatValue();
        switch (this.op.ordinal()) {
            case 0: {
                return d == this.min;
            }
            case 1: {
                return d > this.min;
            }
            case 2: {
                return d >= this.min;
            }
            case 3: {
                return d < this.max;
            }
            case 4: {
                return d <= this.max;
            }
            case 5: {
                return d >= this.min && d <= this.max;
            }
        }
        return false;
    }

    public String toString() {
        return "RangedFloat{min=" + this.min + ", max=" + this.max + ", op=" + String.valueOf((Object)this.op) + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        RANGE;

    }
}

