/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedDouble {
    protected final Operation op;
    protected double min;
    protected double max;

    public RangedDouble(String value) {
        this(value, false);
    }

    public RangedDouble(String value, boolean squared) {
        if (value.startsWith(">=")) {
            s = value.substring(2);
            this.min = Double.parseDouble(s);
            this.max = Double.MAX_VALUE;
            this.op = Operation.GREATER_THAN_OR_EQUAL;
        } else if (value.startsWith("<=")) {
            s = value.substring(2);
            this.min = -1.7976931348623157E308;
            this.max = Double.parseDouble(s);
            this.op = Operation.LESS_THAN_OR_EQUAL;
        } else if (value.startsWith(">")) {
            s = value.substring(1);
            this.min = Double.parseDouble(s);
            this.max = Double.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            s = value.substring(1);
            this.min = -1.7976931348623157E308;
            this.max = Double.parseDouble(s);
            this.op = Operation.LESS_THAN;
        } else if (value.contains("to")) {
            split = value.split("to");
            this.min = Double.parseDouble(split[0]);
            this.max = Double.parseDouble(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            split = value.split("-");
            this.min = Double.parseDouble(split[0]);
            this.max = Double.parseDouble(split[1]);
            this.op = Operation.RANGE;
        } else {
            this.max = this.min = Double.parseDouble(value);
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            double tmp = this.min;
            this.min = this.max;
            this.max = tmp;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        double d = ((Number)o).doubleValue();
        switch (this.op.ordinal()) {
            case 0: {
                return d == this.min;
            }
            case 1: {
                return d > this.min;
            }
            case 2: {
                return d >= this.min;
            }
            case 3: {
                return d < this.max;
            }
            case 4: {
                return d <= this.max;
            }
            case 5: {
                return d >= this.min && d <= this.max;
            }
        }
        return false;
    }

    public boolean equalsSquared(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        double d = ((Number)o).doubleValue();
        double sqMin = Math.pow(this.min, 2.0);
        double sqMax = Math.pow(this.max, 2.0);
        switch (this.op.ordinal()) {
            case 0: {
                return d == sqMin;
            }
            case 1: {
                return d > sqMin;
            }
            case 2: {
                return d >= sqMin;
            }
            case 3: {
                return d < sqMax;
            }
            case 4: {
                return d <= sqMax;
            }
            case 5: {
                return d >= sqMin && d <= sqMax;
            }
        }
        return false;
    }

    public String toString() {
        return "RangedDouble{min=" + this.min + ", max=" + this.max + ", op=" + String.valueOf((Object)this.op) + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        RANGE;

    }
}

