/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public enum AngleUnit {
    DEGREES{

        @Override
        public double toRadians(double value) {
            return Math.toRadians(value);
        }

        @Override
        public double fromRadians(double radians2) {
            return Math.toDegrees(radians2);
        }

        @Override
        public String[] suffixes() {
            return new String[]{"d"};
        }
    }
    ,
    RADIANS{

        @Override
        public double toRadians(double value) {
            return value;
        }

        @Override
        public double fromRadians(double radians2) {
            return radians2;
        }

        @Override
        public String[] suffixes() {
            return new String[]{"r"};
        }
    }
    ,
    SLOPE{

        @Override
        public double toRadians(double value) {
            return Math.atan(value);
        }

        @Override
        public double fromRadians(double radians2) {
            return Math.tan(radians2);
        }

        @Override
        public String[] suffixes() {
            return new String[]{"s"};
        }
    };


    public abstract double toRadians(double var1);

    public abstract double fromRadians(double var1);

    public abstract String[] suffixes();

    public static AngleUnit fromSuffix(String suffix) {
        if (suffix == null) {
            return null;
        }
        String s2 = suffix.toLowerCase();
        for (AngleUnit u : AngleUnit.values()) {
            for (String suf : u.suffixes()) {
                if (!s2.equals(suf)) continue;
                return u;
            }
        }
        return null;
    }
}

