/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.metadata;

import com.google.common.base.Preconditions;
import io.lumine.mythic.bukkit.utils.metadata.TransientValue;
import java.util.concurrent.TimeUnit;

public final class ExpiringValue<T>
implements TransientValue<T> {
    private final T value;
    private final long expireAt;

    public static <T> ExpiringValue<T> of(T value, long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be >= 0");
        Preconditions.checkNotNull(value, (Object)"value");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        long millis = unit.toMillis(duration);
        long expireAt = System.currentTimeMillis() + millis;
        return new ExpiringValue<T>(value, expireAt);
    }

    private ExpiringValue(T value, long expireAt) {
        this.value = value;
        this.expireAt = expireAt;
    }

    @Override
    public T getOrNull() {
        return this.shouldExpire() ? null : (T)this.value;
    }

    @Override
    public boolean shouldExpire() {
        return System.currentTimeMillis() > this.expireAt;
    }
}

