/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.stat.descriptive.moment;

import io.lumine.mythic.bukkit.utils.lib.math3.exception.MathIllegalArgumentException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NullArgumentException;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.descriptive.moment.Mean;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.descriptive.moment.ThirdMoment;
import io.lumine.mythic.bukkit.utils.lib.math3.util.FastMath;
import io.lumine.mythic.bukkit.utils.lib.math3.util.MathUtils;
import java.io.Serializable;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 7101857578996691352L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment m32) {
        this.incMoment = false;
        this.moment = m32;
    }

    public Skewness(Skewness original) throws NullArgumentException {
        Skewness.copy(original, this);
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double variance = this.moment.m2 / (double)(this.moment.n - 1L);
        if (variance < 1.0E-19) {
            return 0.0;
        }
        double n0 = this.moment.getN();
        return n0 * this.moment.m3 / ((n0 - 1.0) * (n0 - 2.0) * FastMath.sqrt(variance) * variance);
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double skew = Double.NaN;
        if (this.test(values, begin, length) && length > 2) {
            Mean mean = new Mean();
            double m4 = mean.evaluate(values, begin, length);
            double accum = 0.0;
            double accum2 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                double d = values[i] - m4;
                accum += d * d;
                accum2 += d;
            }
            double variance = (accum - accum2 * accum2 / (double)length) / (double)(length - 1);
            double accum3 = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                double d = values[i] - m4;
                accum3 += d * d * d;
            }
            double n0 = length;
            skew = n0 / ((n0 - 1.0) * (n0 - 2.0)) * (accum3 /= variance * FastMath.sqrt(variance));
        }
        return skew;
    }

    public Skewness copy() {
        Skewness result = new Skewness();
        Skewness.copy(this, result);
        return result;
    }

    public static void copy(Skewness source, Skewness dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.setData(source.getDataRef());
        dest.moment = new ThirdMoment(source.moment.copy());
        dest.incMoment = source.incMoment;
    }
}

