/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.distribution;

import io.lumine.mythic.bukkit.utils.lib.math3.distribution.MultivariateRealDistribution;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NotStrictlyPositiveException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.util.Localizable;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.util.LocalizedFormats;
import io.lumine.mythic.bukkit.utils.lib.math3.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator rng, int n) {
        this.random = rng;
        this.dimension = n;
    }

    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
    }

    public int getDimension() {
        return this.dimension;
    }

    public abstract double[] sample();

    public double[][] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[][] out = new double[sampleSize][this.dimension];
        for (int i = 0; i < sampleSize; ++i) {
            out[i] = this.sample();
        }
        return out;
    }
}

