/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Meta;
import io.lumine.mythic.bukkit.utils.lib.jooq.Queries;
import io.lumine.mythic.bukkit.utils.lib.jooq.Query;
import io.lumine.mythic.bukkit.utils.lib.jooq.Source;
import io.lumine.mythic.bukkit.utils.lib.jooq.Version;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.MigrationSchema;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataDefinitionException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractNode;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.MigrationImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class VersionImpl
extends AbstractNode<Version>
implements Version {
    final DSLContext ctx;
    final Meta meta;
    final List<Parent> parents;

    private VersionImpl(Configuration configuration, String id, Meta meta, Version root, List<Parent> parents) {
        super(configuration, id, null, null, root);
        this.ctx = configuration.dsl();
        this.meta = meta != null ? meta : VersionImpl.init(this.ctx);
        this.parents = parents;
    }

    private static final Meta init(DSLContext ctx) {
        Meta result = ctx.meta("");
        MigrationSchema ds = ctx.settings().getMigrationDefaultSchema();
        if (ds != null) {
            result = result.apply(DSL.createSchemaIfNotExists(MigrationImpl.schema(ds)));
        }
        return result;
    }

    VersionImpl(Configuration configuration, String id, Meta meta, Version root, Version parent, Queries queries) {
        this(configuration, id, meta, root, Arrays.asList(new Parent((VersionImpl)parent, queries)));
    }

    VersionImpl(Configuration configuration, String id, Meta meta, Version root, Version[] parents) {
        this(configuration, id, meta, root, VersionImpl.wrap(parents));
    }

    VersionImpl(Configuration configuration, String id) {
        this(configuration, id, (Meta)null, (Version)null, Arrays.asList(new Parent[0]));
    }

    private static List<Parent> wrap(Version[] parents) {
        return Tools.map(parents, p -> new Parent((VersionImpl)p, null));
    }

    @Override
    public final Meta meta() {
        return this.meta;
    }

    @Override
    public final List<Version> parents() {
        return new AbstractList<Version>(){

            @Override
            public Version get(int index) {
                return VersionImpl.this.parents.get((int)index).version;
            }

            @Override
            public int size() {
                return VersionImpl.this.parents.size();
            }
        };
    }

    @Override
    public final Version apply(String newId, Query ... migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, Collection<? extends Query> migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, String migration) {
        return this.apply(newId, this.ctx.parser().parse(migration));
    }

    @Override
    public final Version apply(String newId, Queries migration) {
        return new VersionImpl(this.ctx.configuration(), newId, this.meta().apply(migration), (Version)this.root, this, migration);
    }

    @Override
    public final Queries migrateTo(Version version) {
        if (this.equals(version)) {
            return this.ctx.queries(new Query[0]);
        }
        VersionImpl subgraph = ((VersionImpl)version).subgraphTo(this);
        if (subgraph == null) {
            throw new DataDefinitionException("No forward path available between versions " + this.id() + " and " + version.id() + ". Use Settings.migrationAllowsUndo to enable this feature.");
        }
        return this.migrateTo(subgraph, this.ctx.queries(new Query[0]));
    }

    private final VersionImpl subgraphTo(VersionImpl ancestor) {
        ArrayList<Parent> list = null;
        for (Parent parent : this.parents) {
            if (parent.version.equals(ancestor)) {
                if (list == null) {
                    list = new ArrayList<Parent>();
                }
                list.add(new Parent(new VersionImpl(this.ctx.configuration(), parent.version.id(), parent.version.meta, (Version)this.root, Collections.emptyList()), parent.queries));
                continue;
            }
            VersionImpl p = parent.version.subgraphTo(ancestor);
            if (p == null) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(new Parent(p, parent.queries));
        }
        return list == null ? null : new VersionImpl(this.ctx.configuration(), this.id(), this.meta, (Version)this.root, list);
    }

    private final Queries migrateTo(VersionImpl target, Queries result) {
        if (!target.forceApply()) {
            return this.meta().migrateTo(target.meta());
        }
        for (Parent parent : target.parents) {
            result = this.migrateTo(parent.version, result);
            if (parent.queries != null) {
                result = result.concat(parent.queries);
                continue;
            }
            result = result.concat(parent.version.meta().migrateTo(target.meta()));
        }
        return result;
    }

    private final boolean forceApply() {
        return Tools.anyMatch(this.parents, p -> p.queries != null || p.version.forceApply());
    }

    @Override
    public final Version commit(String newId, String ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Source ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Meta newMeta) {
        return new VersionImpl(this.ctx.configuration(), newId, newMeta, (Version)this.root, new Version[]{this});
    }

    final Version commit(String newId, Meta newMeta, Queries migration) {
        return new VersionImpl(this.ctx.configuration(), newId, newMeta, (Version)this.root, this, migration);
    }

    @Override
    public final Version merge(String newId, Version with) {
        Meta m4 = this.commonAncestor(with).meta();
        return new VersionImpl(this.ctx.configuration(), newId, m4.apply(m4.migrateTo(this.meta()).concat(m4.migrateTo(with.meta()))), (Version)this.root, new Version[]{this, with});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        return this.id().equals(other.id());
    }

    public String toString() {
        return "-- Version: " + this.id() + "\n" + String.valueOf(this.meta());
    }

    private record Parent(VersionImpl version, Queries queries) {
        @Override
        public String toString() {
            return this.version.toString();
        }
    }
}

