/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function1;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ToHex
extends AbstractField<String>
implements QOM.ToHex {
    final Field<? extends Number> value;

    ToHex(Field<? extends Number> value) {
        super(Names.N_TO_HEX, Tools.allNotNull(SQLDataType.VARCHAR, value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                return true;
            }
            case H2: {
                return false;
            }
            case SQLITE: {
                return false;
            }
            case TRINO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_HEX, this.getDataType(), this.value));
                break;
            }
            case H2: {
                ctx.visit(DSL.trim(DSL.toChar(this.value, DSL.inline("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"))));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_PRINTF, this.getDataType(), DSL.inline("%X"), this.value));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_TO_BASE, this.getDataType(), this.value, DSL.inline(16)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_TO_HEX, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.ToHex $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.ToHex> $constructor() {
        return a1 -> new ToHex((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ToHex) {
            QOM.ToHex o = (QOM.ToHex)that;
            return StringUtils.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

