/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Like;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class StartsWith<T>
extends AbstractCondition
implements QOM.StartsWith<T> {
    final Field<T> string;
    final Field<T> prefix;

    StartsWith(Field<T> string, Field<T> prefix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, prefix.getDataType()));
        this.prefix = Tools.nullableIf(false, Tools.nullSafe(prefix, string.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                return false;
            }
            case DERBY: {
                return false;
            }
            case DUCKDB: 
            case TRINO: {
                return true;
            }
            case CLICKHOUSE: {
                return true;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                this.acceptLike(ctx);
                break;
            }
            case DERBY: {
                this.acceptPosition(ctx);
                break;
            }
            case DUCKDB: 
            case TRINO: {
                ctx.visit(DSL.function(Names.N_STARTS_WITH, SQLDataType.BOOLEAN, this.string, this.prefix));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_startsWith, SQLDataType.BOOLEAN, this.string, this.prefix));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_STARTS_WITH, SQLDataType.BOOLEAN, this.string, this.prefix));
            }
        }
    }

    private final void acceptLike(Context<?> ctx) {
        ctx.visit(this.string.like(DSL.concat(Tools.escapeForLike(this.prefix, ctx.configuration()), DSL.inline("%")), '!'));
    }

    private final void acceptPosition(Context<?> ctx) {
        ctx.visit(DSL.position(Like.requiresStringCast(this.string), Like.requiresStringCast(this.prefix)).eq(DSL.inline(1)));
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.prefix;
    }

    @Override
    public final QOM.StartsWith<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.StartsWith<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.StartsWith<T>> $constructor() {
        return (a1, a2) -> new StartsWith(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.StartsWith) {
            QOM.StartsWith o = (QOM.StartsWith)that;
            return StringUtils.equals(this.$string(), o.$string()) && StringUtils.equals(this.$prefix(), o.$prefix());
        }
        return super.equals(that);
    }
}

