/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Check;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Domain;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.ForeignKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.Index;
import io.lumine.mythic.bukkit.utils.lib.jooq.Key;
import io.lumine.mythic.bukkit.utils.lib.jooq.Meta;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.Qualified;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.Sequence;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortField;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortOrder;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.UniqueKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Convert;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.XmlUtils;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.CheckConstraint;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Column;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.DomainConstraint;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.IndexColumnUsage;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.InformationSchema;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.KeyColumnUsage;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.ReferentialConstraint;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.TableConstraint;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.TableConstraintType;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.TableType;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.View;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class InformationSchemaExport {
    static final InformationSchema exportTables(Configuration configuration, List<Table<?>> tables) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet<Schema> includedSchemas = new LinkedHashSet<Schema>();
        LinkedHashSet includedTables = new LinkedHashSet(tables);
        for (Table<Object> t2 : tables) {
            if (t2.getSchema() == null) continue;
            includedSchemas.add(t2.getSchema());
        }
        for (Schema s2 : includedSchemas) {
            if (s2.getCatalog() == null) continue;
            includedCatalogs.add(s2.getCatalog());
        }
        for (Catalog c : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c);
        }
        for (Schema s2 : includedSchemas) {
            InformationSchemaExport.exportSchema0(result, s2);
        }
        for (Table<Object> t2 : tables) {
            InformationSchemaExport.exportTable0(configuration, result, t2, includedTables);
        }
        return result;
    }

    static final InformationSchema exportSchemas(Configuration configuration, List<Schema> schemas) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Schema s2 : schemas) {
            if (s2.getCatalog() != null) {
                includedCatalogs.add(s2.getCatalog());
            }
            includedTables.addAll(s2.getTables());
        }
        for (Catalog c : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c);
        }
        for (Schema s2 : schemas) {
            InformationSchemaExport.exportSchema0(result, s2);
            for (Domain<?> domain : s2.getDomains()) {
                InformationSchemaExport.exportDomain0(configuration, result, domain);
            }
            for (Table table : s2.getTables()) {
                InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
            }
            for (Sequence sequence : s2.getSequences()) {
                InformationSchemaExport.exportSequence0(configuration, result, sequence);
            }
        }
        return result;
    }

    static final InformationSchema export(Configuration configuration, Meta meta) {
        InformationSchema result = InformationSchemaExport.exportCatalogs(configuration, meta.getCatalogs());
        return result;
    }

    static final InformationSchema exportCatalogs(Configuration configuration, List<Catalog> catalogs) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Catalog c : catalogs) {
            for (Schema s2 : c.getSchemas()) {
                includedTables.addAll(s2.getTables());
            }
        }
        for (Catalog c : catalogs) {
            InformationSchemaExport.exportCatalog0(result, c);
            for (Schema s2 : c.getSchemas()) {
                InformationSchemaExport.exportSchema0(result, s2);
                for (Domain<?> domain : s2.getDomains()) {
                    InformationSchemaExport.exportDomain0(configuration, result, domain);
                }
                for (Table table : s2.getTables()) {
                    InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
                }
                for (Sequence sequence : s2.getSequences()) {
                    InformationSchemaExport.exportSequence0(configuration, result, sequence);
                }
            }
        }
        return result;
    }

    private static final void exportDomain0(Configuration configuration, InformationSchema result, Domain<?> d) {
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Domain id = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Domain();
        String catalogName = InformationSchemaExport.catalogName(d);
        String schemaName = InformationSchemaExport.schemaName(d);
        String domainName = d.getName();
        if (!StringUtils.isBlank(catalogName)) {
            id.setDomainCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            id.setDomainSchema(schemaName);
        }
        id.setDomainName(domainName);
        id.setComment(d.getComment());
        id.setDataType(d.getDataType().getTypeName(configuration));
        if (d.getDataType().lengthDefined()) {
            id.setCharacterMaximumLength(d.getDataType().length());
        }
        if (d.getDataType().precisionDefined()) {
            id.setNumericPrecision(d.getDataType().precision());
        }
        if (d.getDataType().scaleDefined()) {
            id.setNumericScale(d.getDataType().scale());
        }
        result.getDomains().add(id);
        for (Check<?> c : d.getChecks()) {
            DomainConstraint idc = new DomainConstraint();
            CheckConstraint icc = new CheckConstraint();
            if (!StringUtils.isBlank(catalogName)) {
                idc.setDomainCatalog(catalogName);
                idc.setConstraintCatalog(catalogName);
                icc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                idc.setDomainSchema(schemaName);
                idc.setConstraintSchema(schemaName);
                icc.setConstraintSchema(schemaName);
            }
            idc.setDomainName(domainName);
            idc.setConstraintName(c.getName());
            icc.setConstraintName(c.getName());
            icc.setCheckClause(configuration.dsl().render(c.condition()));
            result.getDomainConstraints().add(idc);
            result.getCheckConstraints().add(icc);
        }
    }

    private static final void exportSequence0(Configuration configuration, InformationSchema result, Sequence<?> q) {
        Param p;
        Field<?> field;
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Sequence iq = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Sequence();
        String catalogName = InformationSchemaExport.catalogName(q);
        String schemaName = InformationSchemaExport.schemaName(q);
        if (!StringUtils.isBlank(catalogName)) {
            iq.setSequenceCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            iq.setSequenceSchema(schemaName);
        }
        iq.setSequenceName(q.getName());
        iq.setComment(q.getComment());
        iq.setDataType(q.getDataType().getTypeName(configuration));
        if (q.getDataType().lengthDefined()) {
            iq.setCharacterMaximumLength(q.getDataType().length());
        }
        if (q.getDataType().precisionDefined()) {
            iq.setNumericPrecision(q.getDataType().precision());
        }
        if (q.getDataType().scaleDefined()) {
            iq.setNumericScale(q.getDataType().scale());
        }
        if (q.getStartWith() != null) {
            String string;
            field = q.getStartWith();
            if (field instanceof Param) {
                p = (Param)field;
                string = p.getValue();
            } else {
                string = q.getStartWith().toString();
            }
            iq.setStartValue(Convert.convert((Object)string, BigInteger.class));
        }
        if (q.getIncrementBy() != null) {
            String string;
            field = q.getIncrementBy();
            if (field instanceof Param) {
                p = (Param)field;
                string = p.getValue();
            } else {
                string = q.getIncrementBy().toString();
            }
            iq.setIncrement(Convert.convert((Object)string, BigInteger.class));
        }
        if (q.getMinvalue() != null) {
            String string;
            field = q.getMinvalue();
            if (field instanceof Param) {
                p = (Param)field;
                string = p.getValue();
            } else {
                string = q.getMinvalue().toString();
            }
            iq.setMinimumValue(Convert.convert((Object)string, BigInteger.class));
        }
        if (q.getMaxvalue() != null) {
            String string;
            field = q.getMaxvalue();
            if (field instanceof Param) {
                p = (Param)field;
                string = p.getValue();
            } else {
                string = q.getMaxvalue().toString();
            }
            iq.setMaximumValue(Convert.convert((Object)string, BigInteger.class));
        }
        iq.setCycleOption(q.getCycle());
        if (q.getCache() != null) {
            String string;
            field = q.getCache();
            if (field instanceof Param) {
                p = (Param)field;
                string = p.getValue();
            } else {
                string = q.getCache().toString();
            }
            iq.setCache(Convert.convert((Object)string, BigInteger.class));
        }
        result.getSequences().add(iq);
    }

    private static final void exportCatalog0(InformationSchema result, Catalog c) {
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Catalog ic = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Catalog();
        if (!StringUtils.isBlank(c.getName())) {
            ic.setCatalogName(c.getName());
            ic.setComment(c.getComment());
            result.getCatalogs().add(ic);
        }
    }

    private static final void exportSchema0(InformationSchema result, Schema s2) {
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Schema is = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Schema();
        String catalogName = InformationSchemaExport.catalogName(s2);
        if (!StringUtils.isBlank(catalogName)) {
            is.setCatalogName(catalogName);
        }
        if (!StringUtils.isBlank(s2.getName())) {
            is.setSchemaName(s2.getName());
            is.setComment(s2.getComment());
            result.getSchemata().add(is);
        }
    }

    private static final void exportTable0(Configuration configuration, InformationSchema result, Table<?> t2, Set<Table<?>> includedTables) {
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Table it = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Table();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            it.setTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            it.setTableSchema(schemaName);
        }
        switch (t2.getOptions().type()) {
            case MATERIALIZED_VIEW: {
                it.setTableType(TableType.MATERIALIZED_VIEW);
                break;
            }
            case VIEW: {
                it.setTableType(TableType.VIEW);
                break;
            }
            case TEMPORARY: {
                it.setTableType(TableType.GLOBAL_TEMPORARY);
                break;
            }
            default: {
                it.setTableType(TableType.BASE_TABLE);
            }
        }
        it.setTableName(t2.getName());
        it.setComment(t2.getComment());
        result.getTables().add(it);
        if (t2.getOptions().type() == TableOptions.TableType.VIEW) {
            View iv = new View();
            if (!StringUtils.isBlank(catalogName)) {
                iv.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                iv.setTableSchema(schemaName);
            }
            iv.setTableName(t2.getName());
            iv.setViewDefinition(t2.getOptions().source());
            result.getViews().add(iv);
        }
        Field<?>[] fields = t2.fieldsIncludingHidden().fields();
        for (int i = 0; i < fields.length; ++i) {
            Field<?> field = fields[i];
            DataType type = field.getDataType();
            Column ic = new Column();
            if (!StringUtils.isBlank(catalogName)) {
                ic.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic.setTableSchema(schemaName);
            }
            ic.setTableName(t2.getName());
            ic.setColumnName(field.getName());
            ic.setComment(field.getComment());
            ic.setDataType(type.getTypeName(configuration));
            if (type.lengthDefined()) {
                ic.setCharacterMaximumLength(type.length());
            }
            if (type.precisionDefined()) {
                ic.setNumericPrecision(type.precision());
            }
            if (type.scaleDefined()) {
                ic.setNumericScale(type.scale());
            }
            ic.setColumnDefault(DSL.using(configuration).render(type.defaultValue()));
            ic.setIsNullable(type.nullable());
            ic.setOrdinalPosition(i + 1);
            ic.setHidden(type.hidden());
            ic.setReadonly(type.readonly());
            if (type.computed()) {
                ic.setIsGenerated(type.computed());
                ic.setGenerationExpression(DSL.using(configuration).render(type.generatedAlwaysAs()));
                ic.setGenerationOption(type.generationOption() == QOM.GenerationOption.VIRTUAL ? "VIRTUAL" : (type.generationOption() == QOM.GenerationOption.STORED ? "STORED" : null));
            }
            result.getColumns().add(ic);
        }
        for (UniqueKey<?> uniqueKey : t2.getKeys()) {
            InformationSchemaExport.exportKey0(result, t2, uniqueKey, uniqueKey.isPrimary() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
        }
        for (ForeignKey foreignKey : t2.getReferences()) {
            if (!includedTables.contains(foreignKey.getKey().getTable())) continue;
            InformationSchemaExport.exportKey0(result, t2, foreignKey, TableConstraintType.FOREIGN_KEY);
        }
        for (Check check : t2.getChecks()) {
            if (!includedTables.contains(check.getTable())) continue;
            InformationSchemaExport.exportCheck0(configuration, result, t2, check);
        }
        for (Index index : t2.getIndexes()) {
            InformationSchemaExport.exportIndex0(result, t2, index);
        }
    }

    private static final void exportCheck0(Configuration configuration, InformationSchema result, Table<?> t2, Check<?> chk) {
        InformationSchemaExport.exportTableConstraint(result, t2, chk.getName(), TableConstraintType.CHECK);
        CheckConstraint c = new CheckConstraint();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            c.setConstraintCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            c.setConstraintSchema(schemaName);
        }
        c.setConstraintName(chk.getName());
        c.setCheckClause(configuration.dsl().render(chk.condition()));
        result.getCheckConstraints().add(c);
    }

    private static final void exportIndex0(InformationSchema result, Table<?> t2, Index index) {
        io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Index i = new io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.Index();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        if (!StringUtils.isBlank(catalogName)) {
            i.withIndexCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            i.withIndexSchema(schemaName).withTableSchema(schemaName);
        }
        i.setIndexName(index.getName());
        i.setTableName(t2.getName());
        i.setIsUnique(index.getUnique());
        result.getIndexes().add(i);
        int position = 1;
        for (SortField<?> sortField : index.getFields()) {
            IndexColumnUsage ic = new IndexColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                ic.withIndexCatalog(catalogName).withTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic.withIndexSchema(schemaName).withTableSchema(schemaName);
            }
            ic.setIndexName(index.getName());
            ic.setTableName(t2.getName());
            ic.setOrdinalPosition(position++);
            ic.setColumnName(sortField.getName());
            ic.setIsDescending(sortField.getOrder() == SortOrder.DESC);
            result.getIndexColumnUsages().add(ic);
        }
    }

    private static final void exportKey0(InformationSchema result, Table<?> t2, Key<?> key, TableConstraintType constraintType) {
        InformationSchemaExport.exportTableConstraint(result, t2, key.getName(), constraintType);
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        int i = 0;
        for (Field field : key.getFields()) {
            KeyColumnUsage kc = new KeyColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                kc.setConstraintCatalog(catalogName);
                kc.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                kc.setConstraintSchema(schemaName);
                kc.setTableSchema(schemaName);
            }
            kc.setColumnName(field.getName());
            kc.setTableName(t2.getName());
            kc.setOrdinalPosition(++i);
            kc.setConstraintName(key.getName());
            result.getKeyColumnUsages().add(kc);
        }
        if (key instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)key;
            ReferentialConstraint referentialConstraint = new ReferentialConstraint();
            UniqueKey uk = fk.getKey();
            String ukCatalogName = InformationSchemaExport.catalogName(uk.getTable());
            String ukSchemaName = InformationSchemaExport.schemaName(uk.getTable());
            if (!StringUtils.isBlank(catalogName)) {
                referentialConstraint.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(ukCatalogName)) {
                referentialConstraint.setUniqueConstraintCatalog(ukCatalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                referentialConstraint.setConstraintSchema(schemaName);
            }
            if (!StringUtils.isBlank(ukSchemaName)) {
                referentialConstraint.setUniqueConstraintSchema(ukSchemaName);
            }
            referentialConstraint.setConstraintName(key.getName());
            referentialConstraint.setUniqueConstraintName(uk.getName());
            referentialConstraint.setDeleteRule(XmlUtils.foreignKeyRule(fk.getDeleteRule()));
            referentialConstraint.setUpdateRule(XmlUtils.foreignKeyRule(fk.getUpdateRule()));
            result.getReferentialConstraints().add(referentialConstraint);
        }
    }

    private static final void exportTableConstraint(InformationSchema result, Table<?> t2, String constraintName, TableConstraintType constraintType) {
        TableConstraint tc = new TableConstraint();
        String catalogName = InformationSchemaExport.catalogName(t2);
        String schemaName = InformationSchemaExport.schemaName(t2);
        tc.setConstraintName(constraintName);
        tc.setConstraintType(constraintType);
        if (!StringUtils.isBlank(catalogName)) {
            tc.withConstraintCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            tc.withConstraintSchema(schemaName).withTableSchema(schemaName);
        }
        tc.setTableName(t2.getName());
        result.getTableConstraints().add(tc);
    }

    private static final String catalogName(Schema s2) {
        return s2.getCatalog() == null ? null : s2.getCatalog().getName();
    }

    private static final String catalogName(Qualified q) {
        return q.getCatalog() == null ? null : q.getCatalog().getName();
    }

    private static final String schemaName(Qualified q) {
        return q.getSchema() == null ? null : q.getSchema().getName();
    }

    private InformationSchemaExport() {
    }
}

