/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Parser;
import io.lumine.mythic.bukkit.utils.lib.jooq.Queries;
import io.lumine.mythic.bukkit.utils.lib.jooq.RenderContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.TransactionContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.Settings;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDiagnosticsContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DiagnosticsListeners;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DiagnosticsStatement;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ParserException;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.DefaultConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

final class DiagnosticsConnection
extends DefaultConnection {
    static final int LRU_SIZE_GLOBAL = 50000;
    static final int LRU_SIZE_LOCAL = 500;
    static final int DUP_SIZE = 500;
    final Configuration configuration;
    final Configuration configurationTranformPatterns;
    final RenderContext normalisingRenderer;
    final Parser parser;
    final DiagnosticsListeners listeners;
    final boolean release;

    DiagnosticsConnection(Configuration configuration) {
        this(configuration, null);
    }

    DiagnosticsConnection(Configuration configuration, Connection c) {
        super(c != null ? c : configuration.connectionProvider().acquire());
        this.release = c == null;
        this.configuration = configuration;
        this.configurationTranformPatterns = configuration.deriveSettings(s2 -> s2.withTransformPatterns(true));
        this.normalisingRenderer = configuration.deriveSettings(s2 -> s2.withParamType(ParamType.FORCE_INDEXED).withInListPadding(true).withInListPadBase(16)).dsl().renderContext();
        this.parser = configuration.dsl().parser();
        this.listeners = DiagnosticsListeners.get(configuration);
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql)), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), autoGeneratedKeys), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnIndexes), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnNames), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql)), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public final void close() throws SQLException {
        if (this.release) {
            this.repeatedSql().clear();
            this.consecutiveAgg().clear();
            this.configuration.connectionProvider().release(this.getDelegate());
        }
    }

    final boolean checkPattern(Predicate<? super Settings> test) {
        return DiagnosticsListeners.checkPattern(this.configuration.settings(), test);
    }

    final boolean check(Predicate<? super Settings> test) {
        return DiagnosticsListeners.check(this.configuration.settings(), test);
    }

    final Map<String, Set<String>> duplicateSql() {
        return DiagnosticsConnection.duplicateSql0(this.configuration);
    }

    static final Map<String, Set<String>> duplicateSql0(Configuration configuration) {
        return (Map)configuration.data().computeIfAbsent("io.lumine.mythic.bukkit.utils.lib.jooq.diagnostics.duplicate-sql", k -> Collections.synchronizedMap(new LRU(50000)));
    }

    final Map<String, List<String>> repeatedSql() {
        return DiagnosticsConnection.repeatedSql0(this.configuration);
    }

    static final Map<String, List<String>> repeatedSql0(Configuration configuration) {
        return DiagnosticsConnection.repetition0(configuration, "io.lumine.mythic.bukkit.utils.lib.jooq.diagnostics.repeated-sql");
    }

    final Map<String, List<String>> consecutiveAgg() {
        return DiagnosticsConnection.consecutiveAgg0(this.configuration);
    }

    static final Map<String, List<String>> consecutiveAgg0(Configuration configuration) {
        return DiagnosticsConnection.repetition0(configuration, "io.lumine.mythic.bukkit.utils.lib.jooq.diagnostics.consecutive-agg");
    }

    private static final Map<String, List<String>> repetition0(Configuration configuration, String cacheKey) {
        return (Map)DiagnosticsConnection.repetitionData(configuration).computeIfAbsent(cacheKey, k -> Collections.synchronizedMap(new LRU(500)));
    }

    private static final Map<Object, Object> repetitionData(Configuration configuration) {
        TransactionContext trx = (TransactionContext)configuration.data("io.lumine.mythic.bukkit.utils.lib.jooq.transaction-context");
        return trx != null ? trx.data() : configuration.data();
    }

    final boolean disabled() {
        return this.configuration.settings().getDiagnosticsConnection() == io.lumine.mythic.bukkit.utils.lib.jooq.conf.DiagnosticsConnection.OFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final String parse(String sql) {
        String normalised;
        if (this.disabled()) {
            return sql;
        }
        Queries queries = null;
        Queries transformed = null;
        try {
            transformed = queries = this.parser.parse(sql);
            normalised = this.normalisingRenderer.render(transformed);
        }
        catch (ParserException exception) {
            normalised = sql;
            this.listeners.exception(new DefaultDiagnosticsContext(this.configuration, "Query could not be parsed.", sql, exception));
        }
        try {
            List<String> repetitions;
            Set<String> duplicates;
            if (this.check(Settings::isDiagnosticsDuplicateStatements) && (duplicates = this.duplicates(this.duplicateSql(), sql, normalised)) != null) {
                this.listeners.duplicateStatements(new DefaultDiagnosticsContext(this.configuration, "Duplicate statements encountered.", sql, normalised, duplicates, null, queries, transformed, null));
            }
            if (this.check(Settings::isDiagnosticsRepeatedStatements) && (repetitions = this.repetitions(this.repeatedSql(), sql, normalised)) != null) {
                this.listeners.repeatedStatements(new DefaultDiagnosticsContext(this.configuration, "Repeated statements encountered.", sql, normalised, null, repetitions, queries, transformed, null));
            }
            if (queries == null) return sql;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable exception) {
            this.listeners.exception(new DefaultDiagnosticsContext(this.configuration, "An unexpected exception has occurred. See exception for details.", sql, normalised, null, null, queries, transformed, exception));
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> duplicates(Map<String, Set<String>> map, String sql, String normalised) {
        Map<String, Set<String>> map2 = map;
        synchronized (map2) {
            Set v = map.computeIfAbsent(normalised, k -> new HashSet());
            if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
                return v;
            }
            return null;
        }
    }

    private final List<String> repetitions(Map<String, List<String>> map, String sql, String normalised) {
        List v = map.computeIfAbsent(normalised, k -> new ArrayList());
        if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
            return v;
        }
        return null;
    }

    static final class LRU<V>
    extends LinkedHashMap<String, V> {
        private final int size;

        LRU(int size) {
            super(size + 1, 1.0f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
            return this.size() > this.size;
        }
    }
}

