/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.ConnectionProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataAccessException;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class DefaultInterpreterConnectionProvider
implements ConnectionProvider {
    private final Configuration configuration;

    DefaultInterpreterConnectionProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    @NotNull
    public Connection acquire() throws DataAccessException {
        SQLDialect family = StringUtils.defaultIfNull(this.configuration.settings().getInterpreterDialect(), SQLDialect.DEFAULT).family();
        try {
            switch (family) {
                case DERBY: {
                    return DriverManager.getConnection("jdbc:derby:memory:db;create=true");
                }
                case H2: 
                case DEFAULT: {
                    return DriverManager.getConnection("jdbc:h2:mem:jooq-ddl-interpretation-" + String.valueOf(UUID.randomUUID()), "sa", "");
                }
                case HSQLDB: {
                    return DriverManager.getConnection("jdbc:hsqldb:.");
                }
                case SQLITE: {
                    return DriverManager.getConnection("jdbc:sqlite::memory:");
                }
            }
            throw new DataAccessException("Unsupported interpretation dialect family: " + String.valueOf((Object)family));
        }
        catch (SQLException e) {
            if ("08001".equals(e.getSQLState())) {
                throw new DataAccessException("The JDBC driver's JAR file was not found on the classpath, which is required for this feature", e);
            }
            throw new DataAccessException("Error while exporting schema", e);
        }
    }

    @Override
    public void release(Connection connection) throws DataAccessException {
        JDBCUtils.safeClose(connection);
    }
}

