/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DMLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.Delete;
import io.lumine.mythic.bukkit.utils.lib.jooq.Insert;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectFieldOrAsterisk;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.Update;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AutoAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CustomQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.MergeImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SelectFieldList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TableAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TopLevelCte;
import java.util.Set;

final class DataChangeDeltaTable<R extends Record>
extends AbstractTable<R>
implements AutoAlias<Table<R>>,
QOM.DataChangeDeltaTable<R> {
    static final Set<SQLDialect> EMULATE_USING_CTE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_OLD_USING_RETURNING = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    static final Set<SQLDialect> EMULATE_NEW_USING_RETURNING = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> EMULATE_FINAL_USING_RETURNING = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    final QOM.ResultOption resultOption;
    final DMLQuery<R> query;
    final Table<R> table;
    final Name alias;

    DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query) {
        this(resultOption, query, DataChangeDeltaTable.table(query));
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table) {
        this(resultOption, query, table, table.getUnqualifiedName());
    }

    private DataChangeDeltaTable(QOM.ResultOption resultOption, DMLQuery<R> query, Table<R> table, Name alias) {
        super(TableOptions.expression(), alias);
        this.resultOption = resultOption;
        this.query = query;
        this.table = table;
        this.alias = alias;
    }

    private static final <R extends Record> Table<R> table(DMLQuery<R> query) {
        if (query instanceof Insert || query instanceof Update || query instanceof Delete) {
            return Tools.abstractDMLQuery(query).table();
        }
        if (query instanceof MergeImpl) {
            MergeImpl m4 = (MergeImpl)query;
            return m4.table();
        }
        throw new IllegalStateException("Unsupported query type: " + String.valueOf(query));
    }

    final boolean emulateUsingReturning(Context<?> ctx) {
        switch (this.resultOption) {
            case OLD: {
                return EMULATE_OLD_USING_RETURNING.contains((Object)ctx.dialect());
            }
            case NEW: {
                return EMULATE_NEW_USING_RETURNING.contains((Object)ctx.dialect());
            }
            case FINAL: {
                return EMULATE_FINAL_USING_RETURNING.contains((Object)ctx.dialect());
            }
        }
        throw new IllegalStateException("Unsupported result option: " + String.valueOf((Object)this.resultOption));
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_USING_CTE.contains((Object)ctx.dialect())) {
            this.acceptCte(ctx);
        } else {
            this.acceptNative(ctx);
        }
    }

    private final void acceptCte(Context<?> ctx) {
        TopLevelCte cte = (TopLevelCte)ctx.data(Tools.SimpleDataKey.DATA_TOP_LEVEL_CTE);
        if (cte != null) {
            cte.add(DSL.name(this.alias).as(DSL.resultQuery("{0}", CustomQueryPart.of(c2 -> c2.visit(this.query).formatSeparator().visit(Keywords.K_RETURNING).sql(' ').visit(new SelectFieldList((SelectFieldOrAsterisk[])this.table.fields()))))));
        }
        ctx.visit(DSL.table(this.alias));
    }

    private final void acceptNative(Context<?> ctx) {
        switch (this.resultOption) {
            case FINAL: {
                ctx.visit(Keywords.K_FINAL);
                break;
            }
            case OLD: {
                ctx.visit(Keywords.K_OLD);
                break;
            }
            case NEW: {
                ctx.visit(Keywords.K_NEW);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported result option: " + String.valueOf((Object)this.resultOption));
            }
        }
        ctx.sql(' ').visit(Keywords.K_TABLE).sqlIndentStart(" (");
        Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE, () -> ctx.visit(this.query).sqlIndentEnd(')'));
    }

    @Override
    public Table<R> as(Name as) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as);
    }

    @Override
    public Table<R> as(Name as, Name ... fieldAliases) {
        return new TableAlias<R>(new DataChangeDeltaTable<R>(this.resultOption, this.query, this.table, as), as, fieldAliases);
    }

    @Override
    public final Table<R> autoAlias(Context<?> ctx, Table<R> t2) {
        return t2.as(this.alias);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.table.getRecordType();
    }

    @Override
    final FieldsImpl<R> fields0() {
        return ((AbstractRow)this.table.as((Name)this.alias).fieldsRow()).fields;
    }

    @Override
    public final QOM.ResultOption $resultOption() {
        return this.resultOption;
    }

    @Override
    public final DMLQuery<R> $query() {
        return this.query;
    }
}

