/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateTypeFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateTypeStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function4;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Type;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CustomField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

final class CreateTypeImpl
extends AbstractDDLQuery
implements QOM.CreateType,
CreateTypeStep,
CreateTypeFinalStep {
    final Type<?> type;
    final boolean ifNotExists;
    QueryPartListView<? extends Field<String>> values;
    QueryPartListView<? extends Field<?>> attributes;
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

    CreateTypeImpl(Configuration configuration, Type<?> type, boolean ifNotExists) {
        this(configuration, type, ifNotExists, null, null);
    }

    CreateTypeImpl(Configuration configuration, Type<?> type, boolean ifNotExists, Collection<? extends Field<String>> values, Collection<? extends Field<?>> attributes) {
        super(configuration);
        this.type = type;
        this.ifNotExists = ifNotExists;
        this.values = new QueryPartList<Field<String>>((Iterable<? extends Field<String>>)values);
        this.attributes = new QueryPartList((Iterable<Field<?>>)attributes);
    }

    @Override
    public final CreateTypeImpl asEnum(String ... values) {
        return this.asEnum(Tools.fields(values));
    }

    @Override
    public final CreateTypeImpl asEnum(Field<String> ... values) {
        return this.asEnum(Arrays.asList(values));
    }

    @Override
    public final CreateTypeImpl asEnum(Collection<? extends Field<String>> values) {
        this.values = new QueryPartList<Field<String>>((Iterable<? extends Field<String>>)values);
        return this;
    }

    @Override
    public final CreateTypeImpl asEnum() {
        return this;
    }

    @Override
    public final CreateTypeImpl as(Field<?> ... attributes) {
        return this.as(Arrays.asList(attributes));
    }

    @Override
    public final CreateTypeImpl as(Collection<? extends Field<?>> attributes) {
        this.attributes = new QueryPartList((Iterable<Field<?>>)attributes);
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_TYPE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE).sql(' ');
        ctx.visit(Keywords.K_TYPE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.type).sql(' ');
        ctx.visit(Keywords.K_AS).sql(' ');
        if (!this.values.isEmpty()) {
            ctx.visit(Keywords.K_ENUM).sql(" (").visit(this.values, ParamType.INLINED).sql(')');
        } else {
            switch (ctx.family()) {
                case DUCKDB: {
                    ctx.visit(Keywords.K_STRUCT).sql(' ');
                }
            }
            ctx.sql('(').visit(new QueryPartList((Iterable<Field<?>>)this.attributes).map(f -> CreateTypeImpl.declare(f)), ParamType.INLINED).sql(')');
        }
    }

    private static final <T> Field<T> declare(Field<T> f) {
        return CustomField.of(f.getUnqualifiedName(), f.getDataType(), c -> {
            c.visit(f.getUnqualifiedName());
            c.sql(' ');
            Tools.toSQLDDLTypeDeclarationForAddition(c, null, f.getDataType());
        });
    }

    @Override
    public final Type<?> $type() {
        return this.type;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<String>> $values() {
        return QOM.unmodifiable(this.values);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $attributes() {
        return QOM.unmodifiable(this.attributes);
    }

    @Override
    public final QOM.CreateType $type(Type<?> newValue) {
        return this.$constructor().apply(newValue, this.$ifNotExists(), this.$values(), this.$attributes());
    }

    @Override
    public final QOM.CreateType $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$type(), newValue, this.$values(), this.$attributes());
    }

    @Override
    public final QOM.CreateType $values(Collection<? extends Field<String>> newValue) {
        return this.$constructor().apply(this.$type(), this.$ifNotExists(), newValue, this.$attributes());
    }

    @Override
    public final QOM.CreateType $attributes(Collection<? extends Field<?>> newValue) {
        return this.$constructor().apply(this.$type(), this.$ifNotExists(), this.$values(), newValue);
    }

    public final Function4<? super Type<?>, ? super Boolean, ? super Collection<? extends Field<String>>, ? super Collection<? extends Field<?>>, ? extends QOM.CreateType> $constructor() {
        return (a1, a2, a3, a4) -> new CreateTypeImpl(this.configuration(), (Type<?>)a1, (boolean)a2, (Collection<? extends Field<String>>)a3, (Collection<? extends Field<?>>)a4);
    }
}

