/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Commit;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.ContentType;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.File;
import io.lumine.mythic.bukkit.utils.lib.jooq.Files;
import io.lumine.mythic.bukkit.utils.lib.jooq.Meta;
import io.lumine.mythic.bukkit.utils.lib.jooq.Query;
import io.lumine.mythic.bukkit.utils.lib.jooq.Source;
import io.lumine.mythic.bukkit.utils.lib.jooq.Tag;
import io.lumine.mythic.bukkit.utils.lib.jooq.Version;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataMigrationVerificationException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractNode;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultParseContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FilesImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TagImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.VersionImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class CommitImpl
extends AbstractNode<Commit>
implements Commit {
    final DSLContext ctx;
    final List<Commit> parents;
    final List<Tag> tags;
    final Map<String, File> delta;
    transient Map<String, File> files;
    final boolean valid;

    CommitImpl(Configuration configuration, String id, String message, String author, Commit root, List<Commit> parents, Collection<? extends File> delta, boolean valid) {
        super(configuration, id, message, author, root);
        if ("root".equals(id) && root != null) {
            throw new DataMigrationVerificationException("Cannot use reserved ID \"root\"");
        }
        this.ctx = configuration.dsl();
        this.parents = parents;
        this.tags = new ArrayList<Tag>();
        this.delta = CommitImpl.map(delta, false);
        this.valid = valid;
        if (delta.size() > this.delta.size()) {
            throw new DataMigrationVerificationException("Path is ambiguous within commit: " + CommitImpl.duplicatePath(delta));
        }
    }

    private static final String duplicatePath(Collection<? extends File> files) {
        HashSet<String> paths = new HashSet<String>();
        for (File file : files) {
            if (paths.add(file.path())) continue;
            return file.path();
        }
        return null;
    }

    private CommitImpl(CommitImpl copy, boolean newValid) {
        super(copy.configuration(), copy.id(), copy.message(), copy.author(), (Commit)copy.root);
        this.ctx = copy.ctx;
        this.parents = copy.parents;
        this.tags = new ArrayList<Tag>(copy.tags);
        this.delta = copy.delta;
        this.files = copy.files;
        this.valid = newValid;
    }

    static final Map<String, File> map(Collection<? extends File> list, boolean applyDeletions) {
        return CommitImpl.apply(new LinkedHashMap<String, File>(), list, applyDeletions);
    }

    static final Map<String, File> apply(Map<String, File> result, Collection<? extends File> list, boolean applyDeletions) {
        for (File file : list) {
            CommitImpl.apply(result, file, applyDeletions);
        }
        return result;
    }

    private static final Map<String, File> apply(Map<String, File> result, File file, boolean applyDeletions) {
        if (applyDeletions && file.content() == null) {
            result.remove(file.path());
        } else {
            result.put(file.path(), file);
        }
        return result;
    }

    private final Map<String, File> initFiles() {
        if (this.parents.isEmpty()) {
            return this.delta;
        }
        Commit parent = this.parents.get(0);
        return CommitImpl.apply(CommitImpl.map(parent.files(), true), this.delta(), true);
    }

    @Override
    public final boolean valid() {
        return this.valid;
    }

    @Override
    public final Commit valid(boolean newValid) {
        return new CommitImpl(this, newValid);
    }

    @Override
    public final List<Commit> parents() {
        return Collections.unmodifiableList(this.parents);
    }

    public final List<Tag> tags() {
        return Collections.unmodifiableList(this.tags);
    }

    @Override
    public final Commit tag(String tagId) {
        return this.tag(tagId, null);
    }

    @Override
    public final Commit tag(String tagId, String tagMessage) {
        CommitImpl result = new CommitImpl(this, this.valid);
        result.tags.add(new TagImpl(tagId, tagMessage));
        return result;
    }

    @Override
    public final Collection<File> delta() {
        return this.delta.values();
    }

    @Override
    public final Collection<File> files() {
        if (this.files == null) {
            this.files = this.initFiles();
        }
        return this.files.values();
    }

    private static final Collection<Source> sources(Collection<File> files) {
        return Tools.map(files, f -> Source.of(f.content()));
    }

    @Override
    public final Collection<Source> sources() {
        return CommitImpl.sources(this.files());
    }

    @Override
    public final Commit commit(String newId, File ... newFiles) {
        return this.commit(newId, "", newFiles);
    }

    @Override
    public final Commit commit(String newId, Collection<? extends File> newFiles) {
        return this.commit(newId, "", newFiles);
    }

    @Override
    public final Commit commit(String newId, String newMessage, File ... newFiles) {
        return this.commit(newId, newMessage, null, Arrays.asList(newFiles));
    }

    @Override
    public final Commit commit(String newId, String newMessage, Collection<? extends File> newFiles) {
        return this.commit(newId, newMessage, null, newFiles);
    }

    @Override
    public final Commit commit(String newId, String newMessage, String newAuthor, File ... newFiles) {
        return this.commit(newId, newMessage, newAuthor, Arrays.asList(newFiles));
    }

    @Override
    public final Commit commit(String newId, String newMessage, String newAuthor, Collection<? extends File> newFiles) {
        return new CommitImpl(this.configuration(), newId, newMessage, newAuthor, (Commit)this.root, Arrays.asList(this), newFiles, this.valid);
    }

    @Override
    public final Commit merge(String newId, Commit with, File ... newFiles) {
        return this.merge(newId, null, with, Arrays.asList(newFiles));
    }

    @Override
    public final Commit merge(String newId, Commit with, Collection<? extends File> newFiles) {
        return this.merge(newId, null, with, newFiles);
    }

    @Override
    public final Commit merge(String newId, String newMessage, Commit with, File ... newFiles) {
        return this.merge(newId, newMessage, null, with, Arrays.asList(newFiles));
    }

    @Override
    public final Commit merge(String newId, String newMessage, Commit with, Collection<? extends File> newFiles) {
        return this.merge(newId, newMessage, null, with, newFiles);
    }

    @Override
    public final Commit merge(String newId, String newMessage, String newAuthor, Commit with, File ... newFiles) {
        return this.merge(newId, newMessage, newAuthor, with, Arrays.asList(newFiles));
    }

    @Override
    public final Commit merge(String newId, String newMessage, String newAuthor, Commit with, Collection<? extends File> newFiles) {
        return new CommitImpl(this.configuration(), newId, newMessage, newAuthor, (Commit)this.root, Arrays.asList(this, with), newFiles, this.valid);
    }

    @Override
    public final Version version() {
        return ((Commit)this.root()).migrateTo(this).to();
    }

    @Override
    public final Meta meta() {
        return this.version().meta();
    }

    @Override
    public final Files migrateTo(Commit resultCommit) {
        if (this.equals(resultCommit)) {
            if (this.equals(this.root())) {
                return FilesImpl.empty(this.ctx.migrations().version("root"));
            }
            return FilesImpl.empty(this.version());
        }
        Commit ancestor = this.commonAncestor(resultCommit);
        if (ancestor.equals(resultCommit)) {
            this.configuration().requireCommercial(() -> "Reverse migrations are a commercial only feature. Please upgrade to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
        }
        return this.migrateTo0(resultCommit);
    }

    private final Files migrateTo0(Commit resultCommit) {
        return this.migrateTo1(resultCommit, false).result();
    }

    private final MigrationHistory migrateTo1(Commit resultCommit, boolean recordPathHistory) {
        HashMap<String, Map<String, File>> pathHistory = recordPathHistory ? new HashMap<String, Map<String, File>>() : null;
        LinkedHashMap<Object, File> history = new LinkedHashMap<Object, File>();
        HashMap<String, CallSite> historyKeys = new HashMap<String, CallSite>();
        LinkedHashMap<String, File> result = new LinkedHashMap<String, File>();
        LinkedHashMap<String, File> tempHistory = new LinkedHashMap<String, File>();
        HashMap<String, String> tempHistoryKeys = new HashMap<String, String>();
        ArrayDeque<Commit> commitHistory = new ArrayDeque<Commit>();
        boolean recordingResult = false;
        boolean hasDeletions = false;
        boolean isRoot = this.equals(this.root());
        Object fromSnapshotCommit = null;
        CommitImpl.history(commitHistory, new HashSet<Commit>(), Arrays.asList(resultCommit));
        for (Commit commit : commitHistory) {
            ArrayList<File> commitFiles = new ArrayList<File>(commit.delta());
            if (isRoot && Tools.anyMatch(commitFiles, f -> f.type() == ContentType.SNAPSHOT)) {
                this.configuration().requireCommercial(() -> "Snapshots are a commercial only feature. Please upgrade to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
            }
            Iterator<File> deletions = Tools.filter(commitFiles.iterator(), f -> f.content() == null);
            for (File file2 : Tools.iterable(deletions)) {
                String remove;
                hasDeletions |= true;
                String path = file2.path();
                String tempKey = (String)tempHistoryKeys.remove(path);
                String tempRemove = tempKey != null ? tempKey : path;
                String key2 = (String)historyKeys.remove(path);
                String string = remove = key2 != null ? key2 : path;
                if (recordingResult && result.remove(tempRemove) == null && file2.type() == ContentType.INCREMENT && history.containsKey(tempRemove)) {
                    result.put(tempRemove, file2);
                } else if (recordingResult && result.remove(remove) == null && file2.type() == ContentType.SCHEMA && history.containsKey(remove)) {
                    result.put(remove, file2);
                } else {
                    history.remove(tempRemove);
                }
                tempHistory.remove(path);
                deletions.remove();
            }
            Iterator<File> increments = Tools.filter(commitFiles.iterator(), f -> f.type() == ContentType.INCREMENT);
            for (File file3 : Tools.iterable(increments)) {
                File oldFile;
                String path = file3.path();
                File file4 = oldFile = recordingResult ? (File)history.get(path) : history.put(path, file3);
                if (oldFile == null && !tempHistory.isEmpty() && !result.containsKey(path)) {
                    CommitImpl.move(tempHistory, result, tempHistoryKeys);
                }
                if (recordingResult) {
                    result.put(path, file3);
                }
                increments.remove();
            }
            Iterator<File> iterator = Tools.filter(commitFiles.iterator(), f -> f.type() == ContentType.SCRIPT);
            boolean hasScripts = false;
            for (File file5 : Tools.iterable(iterator)) {
                File oldFile;
                hasScripts = true;
                String path = file5.path();
                File file6 = oldFile = recordingResult ? (File)history.get(path) : history.put(path, file5);
                if (oldFile == null && !tempHistory.isEmpty() && !result.containsKey(path)) {
                    CommitImpl.move(tempHistory, result, tempHistoryKeys);
                }
                if (recordingResult) {
                    result.put(path, file5);
                }
                iterator.remove();
            }
            Iterator<File> schemas = Tools.filter(commitFiles.iterator(), f -> f.type() == ContentType.SCHEMA);
            for (File file7 : Tools.iterable(schemas)) {
                String path = file7.path();
                String key3 = commit.id() + "-" + path;
                if (hasScripts) {
                    file7 = new IgnoreFile(file7);
                }
                if (recordingResult) {
                    tempHistory.put(path, file7);
                    tempHistoryKeys.put(path, key3);
                } else {
                    history.put(key3, file7);
                    historyKeys.put(path, (CallSite)((Object)key3));
                }
                schemas.remove();
            }
            if (hasScripts) {
                CommitImpl.move(tempHistory, result, tempHistoryKeys);
            }
            recordingResult |= this.id().equals(commit.id());
        }
        CommitImpl.move(tempHistory, result, tempHistoryKeys);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            File historicFile;
            Map.Entry entry = it.next();
            String path = (String)entry.getKey();
            File file8 = (File)entry.getValue();
            if (file8.type() != ContentType.INCREMENT || (historicFile = (File)history.get(path)) == null) continue;
            if (!StringUtils.equals(historicFile.content(), file8.content())) {
                throw new DataMigrationVerificationException("Cannot edit increment file that has already been applied: {file}\nPlease revert the file to its original content:\n\n{content}\n".replace("{file}", file8.path()).replace("{content}", file8.content() == null ? "(File was deleted)" : file8.content()));
            }
            it.remove();
        }
        if (hasDeletions) {
            LinkedHashMap<String, List<String>> keys = new LinkedHashMap<String, List<String>>();
            LinkedHashSet<String> remove = new LinkedHashSet<String>();
            result.forEach((key, file) -> {
                if (file.type() == ContentType.SCHEMA) {
                    keys.computeIfAbsent(file.path(), p -> new ArrayList()).add(key);
                } else {
                    CommitImpl.moveAllButLast(keys, remove);
                }
            });
            CommitImpl.moveAllButLast(keys, remove);
            for (String r : remove) {
                result.remove(r);
            }
        }
        HashMap<String, File> versionFiles = new HashMap<String, File>();
        Version from = this.version(this.ctx.migrations().version("root"), this.id(), versionFiles, history.values());
        Version fromSnapshot = null;
        Version to = this.version(from, resultCommit.id(), versionFiles, result.values());
        return new MigrationHistory(pathHistory, new FilesImpl(from, fromSnapshot, to, result.values()));
    }

    private static final void history(Deque<Commit> commitHistory, Set<Commit> set, List<Commit> commits) {
        for (Commit commit : commits) {
            if (!set.add(commit)) continue;
            commitHistory.push(commit);
        }
        LinkedHashSet p = new LinkedHashSet();
        for (Commit commit : commits) {
            p.addAll(commit.parents());
        }
        if (!p.isEmpty()) {
            ArrayList<Commit> arrayList = new ArrayList<Commit>(p);
            Collections.reverse(arrayList);
            CommitImpl.history(commitHistory, set, arrayList);
        }
    }

    private final Version version(Version from, String newId, Map<String, File> files, Iterable<File> result) {
        Version to = from;
        for (File file : result) {
            if (file.type() == ContentType.SCHEMA) {
                Meta meta = this.ctx.meta(CommitImpl.sources(CommitImpl.apply(files, file, true).values()).toArray(Tools.EMPTY_SOURCE));
                if (file instanceof IgnoreFile) {
                    to = ((VersionImpl)to).commit(newId, meta, this.ctx.queries(new Query[0]));
                    continue;
                }
                to = to.commit(newId, meta);
                continue;
            }
            if (file.type() == ContentType.SCRIPT) {
                to = to.apply(newId, new DefaultParseContext.IgnoreQuery(file.content(), this.ctx.configuration()));
                continue;
            }
            to = to.apply(newId, file.content());
        }
        return to;
    }

    private static final void moveAllButLast(Map<String, List<String>> keys, Set<String> remove) {
        for (List<String> k : keys.values()) {
            if (k.size() <= 1) continue;
            remove.addAll(k.subList(0, k.size() - 1));
        }
        keys.clear();
    }

    private static final void move(Map<String, File> files, Map<String, File> result, Map<String, String> keys) {
        for (File file : files.values()) {
            result.put(keys.get(file.path()), file);
        }
        files.clear();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Commit) {
            return this.id().equals(((Commit)obj).id());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id());
        if (!StringUtils.isBlank(this.message())) {
            sb.append(" - ").append(this.message());
        }
        if (!StringUtils.isBlank(this.author())) {
            sb.append(", author: " + this.author());
        }
        if (!this.tags.isEmpty()) {
            sb.append(", tags: ").append(this.tags);
        }
        return sb.toString();
    }

    private record MigrationHistory(Map<String, Map<String, File>> pathHistory, Files result) {
    }

    private record IgnoreFile(File file) implements File
    {
        @Override
        public final String path() {
            return this.file.path();
        }

        @Override
        public final String name() {
            return this.file.name();
        }

        @Override
        public final String content() {
            return this.file.content();
        }

        @Override
        public final ContentType type() {
            return this.file.type();
        }
    }
}

