/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Binding;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetResultSetContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetSQLInputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingRegisterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSQLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetSQLOutputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converters;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResourceManagingScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.ExceptionTools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ClobBinding;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.R2DBC;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;

public class BlobBinding
implements Binding<byte[], byte[]> {
    static final Set<SQLDialect> NO_SUPPORT_LOBS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline((Object)ctx.convert(this.converter()).value(), SQLDataType.BLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.statement().registerOutParameter(ctx.index(), 2004);
        } else {
            ctx.statement().registerOutParameter(ctx.index(), -2);
        }
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        if (ctx.statement() instanceof R2DBC.R2DBCPreparedStatement) {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = BlobBinding.newBlob(ctx, ctx.value(), ctx.statement().getConnection());
            if (blob == null && ClobBinding.NO_SUPPORT_NULL_LOBS.contains((Object)ctx.dialect())) {
                ctx.statement().setNull(ctx.index(), 2004);
            } else {
                ctx.statement().setBlob(ctx.index(), blob);
            }
        } else {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        }
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.output().writeBlob(BlobBinding.newBlob(ctx, ctx.value(), null));
        } else {
            ctx.output().writeBytes(ctx.value());
        }
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        if (ctx.resultSet() instanceof R2DBC.R2DBCResultSet) {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.resultSet().getBlob(ctx.index());
            ctx.value(blob == null ? null : BlobBinding.readBlob(ctx, blob));
        } else {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.statement().getBlob(ctx.index());
            ctx.value(blob == null ? null : BlobBinding.readBlob(ctx, blob));
        } else {
            ctx.value(ctx.statement().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.input().readBlob();
            ctx.value(blob == null ? null : BlobBinding.readBlob(ctx, blob));
        } else {
            ctx.value(ctx.input().readBytes());
        }
    }

    static final Blob newBlob(ResourceManagingScope scope, byte[] bytes, Connection connection) throws SQLException {
        if (bytes == null) {
            return null;
        }
        switch (scope.dialect()) {
            default: 
        }
        Blob blob = (connection != null ? connection : DefaultExecuteContext.localConnection()).createBlob();
        scope.autoFree(blob);
        blob.setBytes(1L, bytes);
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] readBlob(Scope ctx, Blob blob) throws SQLException {
        try {
            switch (ctx.family()) {
                case DUCKDB: {
                    try {
                        byte[] byArray = blob.getBinaryStream().readAllBytes();
                        return byArray;
                    }
                    catch (IOException e) {
                        SQLException cause = ExceptionTools.getCause(e, SQLException.class);
                        if (cause != null) {
                            throw cause;
                        }
                        throw new SQLException(e);
                    }
                }
            }
            byte[] byArray = blob.getBytes(1L, Tools.asInt(blob.length()));
            return byArray;
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }
}

