/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Named;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataTypeException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractAutoAliasTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Array;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ArrayTableEmulation;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AutoAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RecordImplN;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class ArrayTable
extends AbstractAutoAliasTable<Record>
implements QOM.UNotYetImplemented {
    private final Field<?> array;
    private final FieldsImpl<Record> field;

    ArrayTable(Field<?> array) {
        this(array, Names.N_ARRAY_TABLE);
    }

    ArrayTable(Field<?> array, Name alias) {
        this(array, alias, (Name[])null);
    }

    ArrayTable(Field<?> array, Name alias, Name[] fieldAliases) {
        this(array, alias, ArrayTable.init(ArrayTable.arrayType(array), alias, ArrayTable.fieldAliases(fieldAliases)[0]));
    }

    private ArrayTable(Field<?> array, Name alias, FieldsImpl<Record> fields) {
        super(alias, Tools.map(fields.fields, Named::getUnqualifiedName, Name[]::new));
        this.array = array;
        this.field = fields;
    }

    private static final Class<?> arrayType(Field<?> array) {
        Class arrayType = array.getDataType().getType().isArray() ? array.getDataType().getArrayComponentType() : Object.class;
        return arrayType;
    }

    static final Name[] fieldAliases(Name[] fieldAliases) {
        Name[] nameArray;
        if (Tools.isEmpty(fieldAliases)) {
            Name[] nameArray2 = new Name[1];
            nameArray = nameArray2;
            nameArray2[0] = Names.N_COLUMN_VALUE;
        } else {
            nameArray = fieldAliases;
        }
        return nameArray;
    }

    static final FieldsImpl<Record> init(Class<?> arrayType, Name alias, Name fieldAlias) {
        if (Record.class.isAssignableFrom(arrayType)) {
            try {
                return new FieldsImpl<Record>(Tools.map(Tools.getRecordQualifier(arrayType).fields(), f -> DSL.field(alias.append(f.getUnqualifiedName()), f.getDataType())));
            }
            catch (Exception e) {
                throw new DataTypeException("Bad UDT Type : " + String.valueOf(arrayType), e);
            }
        }
        return new FieldsImpl<Record>(DSL.field(alias.unqualifiedName().append(fieldAlias.unqualifiedName()), DSL.getDataType(arrayType)));
    }

    final ArrayTable construct(Name newAlias, Name[] newFieldAliases) {
        return new ArrayTable(this.array, newAlias, newFieldAliases);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    private final QueryPart table(Configuration configuration) {
        boolean isArray = this.array.getDataType().getType().isArray();
        switch (configuration.family()) {
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                if (isArray && this.array instanceof Param) {
                    return this.emulateParam();
                }
                if (isArray && this.array instanceof Array) {
                    return this.emulateArray();
                }
                return DSL.table("{0}", new QueryPart[]{this.array});
            }
            case CLICKHOUSE: {
                return new ClickHouseUnnest();
            }
        }
        return new StandardUnnest();
    }

    private final QueryPart emulateParam() {
        return new ArrayTableEmulation((Object[])((Param)this.array).getValue(), this.fieldAliases);
    }

    private final QueryPart emulateArray() {
        return new ArrayTableEmulation(((Array)this.array).fields.fields, this.fieldAliases);
    }

    private final class ClickHouseUnnest
    extends DialectArrayTable {
        private ClickHouseUnnest() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visitSubquery(DSL.select(DSL.function(DSL.systemName("arrayJoin"), ArrayTable.this.array.getDataType().getArrayComponentDataType(), DSL.cast(ArrayTable.this.array, ArrayTable.this.array))));
        }
    }

    private final class StandardUnnest
    extends DialectArrayTable {
        private StandardUnnest() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_UNNEST).sql('(').visit(ArrayTable.this.array).sql(")");
        }
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record>
    implements AutoAlias<Table<Record>>,
    QOM.UTransient {
        DialectArrayTable() {
            super(TableOptions.expression(), ArrayTable.this.alias);
        }

        @Override
        public final boolean declaresTables() {
            return true;
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImplN.class;
        }

        @Override
        final FieldsImpl<Record> fields0() {
            return ArrayTable.this.fields0();
        }

        @Override
        public final Table<Record> autoAlias(Context<?> ctx, Table<Record> t2) {
            return t2.as(ArrayTable.this.alias, ArrayTable.this.fieldAliases);
        }
    }
}

