/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function3;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayReplace<T>
extends AbstractField<T[]>
implements QOM.ArrayReplace<T> {
    final Field<T[]> array;
    final Field<T> search;
    final Field<T> replace;

    ArrayReplace(Field<T[]> array, Field<T> search, Field<T> replace) {
        super(Names.N_ARRAY_REPLACE, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array, false), array, search, replace));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
        this.search = Tools.nullSafeNotNull(search, SQLDataType.OTHER);
        this.replace = Tools.nullSafeNotNull(replace, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case H2: 
            case HSQLDB: 
            case TRINO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case H2: 
            case HSQLDB: 
            case TRINO: {
                ctx.visit(DSL.arrayMap(this.array, e -> DSL.when(e.isNotDistinctFrom(this.search), this.replace).else_((Field<T>)e)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_REPLACE, this.getDataType(), this.array, this.search, this.replace));
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array;
    }

    @Override
    public final Field<T> $arg2() {
        return this.search;
    }

    @Override
    public final Field<T> $arg3() {
        return this.replace;
    }

    @Override
    public final QOM.ArrayReplace<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2(), (Field<T>)this.$arg3());
    }

    @Override
    public final QOM.ArrayReplace<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue, (Field<T>)this.$arg3());
    }

    @Override
    public final QOM.ArrayReplace<T> $arg3(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), (Field<T>)this.$arg2(), newValue);
    }

    @Override
    public final Function3<? super Field<T[]>, ? super Field<T>, ? super Field<T>, ? extends QOM.ArrayReplace<T>> $constructor() {
        return (a1, a2, a3) -> new ArrayReplace((Field<T[]>)a1, a2, a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayReplace) {
            QOM.ArrayReplace o = (QOM.ArrayReplace)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$search(), o.$search()) && StringUtils.equals(this.$replace(), o.$replace());
        }
        return super.equals(that);
    }
}

