/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractAutoAliasTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ArrayTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ArrayTableEmulation;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RecordImplN;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class ArrayOfValues
extends AbstractAutoAliasTable<Record>
implements QOM.UNotYetImplemented {
    private final Field<?>[] array;
    private final FieldsImpl<Record> field;

    ArrayOfValues(Field<?>[] array) {
        this(array, Names.N_ARRAY_TABLE);
    }

    ArrayOfValues(Field<?>[] array, Name alias) {
        this(array, alias, null);
    }

    ArrayOfValues(Field<?>[] array, Name alias, Name[] fieldAliases) {
        super(alias, ArrayTable.fieldAliases(fieldAliases));
        Class<Object> arrayType = !Tools.isEmpty(array) ? array[0].getType() : Object.class;
        this.array = array;
        this.field = ArrayTable.init(arrayType, this.alias, this.fieldAliases[0]);
    }

    final ArrayOfValues construct(Name newAlias, Name[] newFieldAliases) {
        return new ArrayOfValues(this.array, newAlias, newFieldAliases);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.visit(new ArrayTableEmulation(this.array, this.fieldAliases));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(new ClickHouseUnnest());
                break;
            }
            default: {
                ctx.visit(new StandardUnnest());
            }
        }
    }

    private final class ClickHouseUnnest
    extends DialectArrayTable {
        private ClickHouseUnnest() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visitSubquery(DSL.select(DSL.function(DSL.systemName("arrayJoin"), SQLDataType.OTHER, DSL.array(ArrayOfValues.this.array))));
        }
    }

    private final class StandardUnnest
    extends DialectArrayTable {
        private StandardUnnest() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_UNNEST).sql('(').visit(Keywords.K_ARRAY).sql('[').visit(QueryPartListView.wrap((QueryPart[])ArrayOfValues.this.array)).sql(']').sql(")");
        }
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record>
    implements QOM.UTransient {
        DialectArrayTable() {
            super(TableOptions.expression(), ArrayOfValues.this.alias);
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImplN.class;
        }

        @Override
        final FieldsImpl<Record> fields0() {
            return ArrayOfValues.this.fields0();
        }
    }
}

