/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayAppend<T>
extends AbstractField<T[]>
implements QOM.ArrayAppend<T> {
    final Field<T[]> array;
    final Field<T> append;

    ArrayAppend(Field<T[]> array, Field<T> append) {
        super(Names.N_ARRAY_APPEND, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), array, false), array, append));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
        this.append = Tools.nullSafeNotNull(append, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                return false;
            }
            case CLICKHOUSE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: 
            case TRINO: {
                ctx.visit(DSL.arrayConcat(this.array, DSL.array(this.append)));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_arrayPushBack, this.getDataType(), this.array, this.append));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_APPEND, this.getDataType(), this.array, this.append));
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array;
    }

    @Override
    public final Field<T> $arg2() {
        return this.append;
    }

    @Override
    public final QOM.ArrayAppend<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.ArrayAppend<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T>, ? extends QOM.ArrayAppend<T>> $constructor() {
        return (a1, a2) -> new ArrayAppend((Field<T[]>)a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayAppend) {
            QOM.ArrayAppend o = (QOM.ArrayAppend)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$append(), o.$append());
        }
        return super.equals(that);
    }
}

