/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.RenderContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Cast;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Collection;
import java.util.Set;

final class Array<T>
extends AbstractField<T[]>
implements QOM.Array<T> {
    static final Set<SQLDialect> REQUIRES_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_SQUARE_BRACKETS = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    final FieldsImpl<Record> fields;

    Array(Collection<? extends Field<T>> fields) {
        super(Names.N_ARRAY, Array.type(fields));
        this.fields = new FieldsImpl(fields);
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public boolean generatesCast() {
        return true;
    }

    private static <T> DataType<T[]> type(Collection<? extends Field<T>> fields) {
        if (fields == null || fields.isEmpty()) {
            return SQLDataType.OTHER.getArrayDataType();
        }
        return fields.iterator().next().getDataType().getArrayDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        Cast.renderCastIf(ctx, c -> {
            if (NO_SUPPORT_SQUARE_BRACKETS.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_ARRAY).sql('(').visit(this.fields).sql(')');
            } else {
                ctx.visit(Keywords.K_ARRAY).sql('[').visit(this.fields).sql(']');
            }
        }, c -> {
            DataType type = (DataType)c.data(Tools.ExtendedDataKey.DATA_EMPTY_ARRAY_BASE_TYPE);
            if (type != null && !type.isOther()) {
                c.sql(type.getCastTypeName(ctx.configuration())).sql("[]");
            } else {
                c.visit(Keywords.K_INT).sql("[]");
            }
        }, () -> this.fields.fields.length == 0 && REQUIRES_CAST.contains((Object)ctx.dialect()) && ctx.castMode() != RenderContext.CastMode.NEVER);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<T>> $elements() {
        return QOM.unmodifiable((QueryPart[])this.fields.fields);
    }
}

