/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.cookie;

import io.lumine.mythic.bukkit.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CommonCookieAttributeHandler;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieOrigin;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.MalformedCookieException;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.SetCookie;
import io.lumine.mythic.bukkit.utils.lib.http.impl.cookie.AbstractCookieAttributeHandler;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

