/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.http.impl.client;

import io.lumine.mythic.bukkit.utils.lib.http.HttpException;
import io.lumine.mythic.bukkit.utils.lib.http.HttpHost;
import io.lumine.mythic.bukkit.utils.lib.http.HttpRequest;
import io.lumine.mythic.bukkit.utils.lib.http.annotation.ThreadSafe;
import io.lumine.mythic.bukkit.utils.lib.http.auth.AuthSchemeProvider;
import io.lumine.mythic.bukkit.utils.lib.http.auth.AuthState;
import io.lumine.mythic.bukkit.utils.lib.http.client.ClientProtocolException;
import io.lumine.mythic.bukkit.utils.lib.http.client.CookieStore;
import io.lumine.mythic.bukkit.utils.lib.http.client.CredentialsProvider;
import io.lumine.mythic.bukkit.utils.lib.http.client.config.RequestConfig;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.CloseableHttpResponse;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.Configurable;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpExecutionAware;
import io.lumine.mythic.bukkit.utils.lib.http.client.methods.HttpRequestWrapper;
import io.lumine.mythic.bukkit.utils.lib.http.client.params.HttpClientParamConfig;
import io.lumine.mythic.bukkit.utils.lib.http.client.protocol.HttpClientContext;
import io.lumine.mythic.bukkit.utils.lib.http.config.Lookup;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ClientConnectionManager;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ClientConnectionRequest;
import io.lumine.mythic.bukkit.utils.lib.http.conn.HttpClientConnectionManager;
import io.lumine.mythic.bukkit.utils.lib.http.conn.ManagedClientConnection;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoute;
import io.lumine.mythic.bukkit.utils.lib.http.conn.routing.HttpRoutePlanner;
import io.lumine.mythic.bukkit.utils.lib.http.conn.scheme.SchemeRegistry;
import io.lumine.mythic.bukkit.utils.lib.http.cookie.CookieSpecProvider;
import io.lumine.mythic.bukkit.utils.lib.http.impl.client.CloseableHttpClient;
import io.lumine.mythic.bukkit.utils.lib.http.impl.execchain.ClientExecChain;
import io.lumine.mythic.bukkit.utils.lib.http.params.HttpParams;
import io.lumine.mythic.bukkit.utils.lib.http.params.HttpParamsNames;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.BasicHttpContext;
import io.lumine.mythic.bukkit.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.bukkit.utils.lib.http.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
class InternalHttpClient
extends CloseableHttpClient
implements Configurable {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain execChain;
    private final HttpClientConnectionManager connManager;
    private final HttpRoutePlanner routePlanner;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;
    private final List<Closeable> closeables;

    public InternalHttpClient(ClientExecChain execChain, HttpClientConnectionManager connManager, HttpRoutePlanner routePlanner, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        Args.notNull(execChain, "HTTP client exec chain");
        Args.notNull(connManager, "HTTP connection manager");
        Args.notNull(routePlanner, "HTTP route planner");
        this.execChain = execChain;
        this.connManager = connManager;
        this.routePlanner = routePlanner;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
        this.closeables = closeables;
    }

    private HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost host = target;
        if (host == null) {
            host = (HttpHost)request.getParams().getParameter("http.default-host");
        }
        return this.routePlanner.determineRoute(host, request, context);
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.auth.target-scope") == null) {
            context.setAttribute("http.auth.target-scope", new AuthState());
        }
        if (context.getAttribute("http.auth.proxy-scope") == null) {
            context.setAttribute("http.auth.proxy-scope", new AuthState());
        }
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", this.defaultConfig);
        }
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request, target);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config == null) {
                HttpParams params = request.getParams();
                if (params instanceof HttpParamsNames) {
                    if (!((HttpParamsNames)((Object)params)).getNames().isEmpty()) {
                        config = HttpClientParamConfig.getRequestConfig(params);
                    }
                } else {
                    config = HttpClientParamConfig.getRequestConfig(params);
                }
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            this.setupContext(localcontext);
            HttpRoute route = this.determineRoute(target, wrapper, localcontext);
            return this.execChain.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public RequestConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public void close() {
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), ex);
                }
            }
        }
    }

    @Override
    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                InternalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                InternalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                InternalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

